/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra.legacy;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.KsDef;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.pentaho.cassandra.legacy.LegacyKeyspace;
import org.pentaho.cassandra.spi.Connection;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;

public class CassandraConnection
implements Connection {
    protected static final Class<?> PKG = CassandraConnection.class;
    private TTransport m_transport;
    public Cassandra.Client m_client;
    public String m_keyspaceName;
    protected String m_host = "localhost";
    protected int m_port = 9160;
    protected String m_username = "";
    protected String m_password = "";
    protected int m_timeout = -1;
    protected int m_maxlength = -1;
    protected Map<String, String> m_options;

    public CassandraConnection() {
    }

    public CassandraConnection(String host, int port) throws Exception {
        this(host, port, null, null, -1);
    }

    public CassandraConnection(String host, int port, int timeout) throws Exception {
        this(host, port, null, null, timeout);
    }

    public CassandraConnection(String host, int port, String username, String password, int timeout) throws Exception {
        this(host, port, username, password, timeout, -1);
    }

    public CassandraConnection(String host, int port, String username, String password, int timeout, int maxlength) throws Exception {
        this.m_host = host;
        this.m_port = port;
        this.m_username = username;
        this.m_password = password;
        this.m_timeout = timeout;
        this.m_maxlength = maxlength;
        this.openConnection();
    }

    public Cassandra.Client getClient() {
        return this.m_client;
    }

    public KsDef describeKeyspace() throws Exception {
        if (this.m_keyspaceName == null || this.m_keyspaceName.length() == 0) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CassandraConnection.Error.NoKeyspaceHasBeenSet", (String[])new String[0]));
        }
        return this.m_client.describe_keyspace(this.m_keyspaceName);
    }

    public void close() {
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkOpen() throws Exception {
        if (this.m_transport == null && this.m_client == null) {
            this.openConnection();
            if (this.m_options != null) {
                for (Map.Entry<String, String> e : this.m_options.entrySet()) {
                    if (!e.getKey().equals("cqlVersion") || !e.getValue().equals("3.0.1")) continue;
                    this.m_client.set_cql_version(e.getValue());
                }
            }
        }
    }

    public void setKeyspace(String keySpace) throws Exception {
        this.checkOpen();
        this.m_client.set_keyspace(keySpace);
        this.m_keyspaceName = keySpace;
    }

    @Override
    public void setHosts(String hosts) {
        String[] parts = hosts.split(",");
        if (parts.length > 0) {
            String[] parts2 = parts[0].split(":");
            if (parts2.length > 0) {
                this.m_host = parts2[0].trim();
            }
            if (parts2.length > 1) {
                try {
                    this.m_port = Integer.parseInt(parts2[1].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setDefaultPort(int port) {
        this.m_port = port;
    }

    @Override
    public void setUsername(String username) {
        this.m_username = username;
    }

    @Override
    public void setPassword(String password) {
        this.m_password = password;
    }

    @Override
    public void setAdditionalOptions(Map<String, String> opts) {
        this.m_options = opts;
        if (this.m_options != null && this.m_options.size() > 0) {
            for (Map.Entry<String, String> entry : this.m_options.entrySet()) {
                String v;
                if (entry.getKey().equalsIgnoreCase("socketTimeout")) {
                    v = entry.getValue().trim();
                    try {
                        this.m_timeout = Integer.parseInt(v);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (!entry.getKey().equalsIgnoreCase("maxLength")) continue;
                v = entry.getValue().trim();
                try {
                    this.m_maxlength = Integer.parseInt(v);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    @Override
    public Map<String, String> getAdditionalOptions() {
        return this.m_options;
    }

    @Override
    public void openConnection() throws Exception {
        TSocket socket = new TSocket(this.m_host, this.m_port);
        if (this.m_timeout > 0) {
            socket.setTimeout(this.m_timeout);
        }
        this.m_transport = this.m_maxlength > 0 ? new TFramedTransport((TTransport)socket, this.m_maxlength) : new TFramedTransport((TTransport)socket);
        TBinaryProtocol protocol = new TBinaryProtocol(this.m_transport);
        this.m_client = new Cassandra.Client((TProtocol)protocol);
        this.m_transport.open();
        if (!Const.isEmpty((String)this.m_username) && !Const.isEmpty((String)this.m_password)) {
            HashMap<String, String> creds = new HashMap<String, String>();
            creds.put("username", this.m_username);
            creds.put("password", this.m_password);
            this.m_client.login(new AuthenticationRequest(creds));
        }
    }

    @Override
    public void closeConnection() throws Exception {
        if (this.m_transport != null) {
            this.m_transport.close();
            this.m_transport = null;
            this.m_client = null;
        }
    }

    @Override
    public Object getUnderlyingConnection() {
        return this;
    }

    @Override
    public boolean supportsCQL() {
        return true;
    }

    @Override
    public boolean supportsNonCQL() {
        return true;
    }

    @Override
    public Keyspace getKeyspace(String keyspacename) throws Exception {
        LegacyKeyspace ks = new LegacyKeyspace();
        ks.setConnection(this);
        ks.setOptions(this.m_options);
        ks.setKeyspace(keyspacename);
        return ks;
    }
}

