/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.pool.HikariPool;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.LeakTask;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.util.FastList;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionProxy
implements IHikariConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProxy.class);
    private static final Set<String> SQL_ERRORS = new HashSet<String>();
    protected final Connection delegate;
    private final FastList<Statement> openStatements;
    private final HikariPool parentPool;
    private final AtomicInteger state;
    private final String defaultCatalog;
    private final long expirationTime;
    private final int defaultIsolationLevel;
    private final boolean defaultAutoCommit;
    private final boolean defaultReadOnly;
    private boolean forceClose;
    private boolean isAutoCommitDirty;
    private boolean isCatalogDirty;
    private boolean isClosed;
    private boolean isReadOnlyDirty;
    private boolean isTransactionIsolationDirty;
    private volatile long lastAccess;
    private long uncloseTime;
    private TimerTask leakTask;
    private final int hashCode;

    protected ConnectionProxy(HikariPool pool, Connection connection, long maxLifetime, int defaultIsolationLevel, boolean defaultAutoCommit, boolean defaultReadOnly, String defaultCatalog) {
        this.parentPool = pool;
        this.delegate = connection;
        this.defaultIsolationLevel = defaultIsolationLevel;
        this.defaultAutoCommit = defaultAutoCommit;
        this.defaultReadOnly = defaultReadOnly;
        this.defaultCatalog = defaultCatalog;
        this.state = new AtomicInteger();
        long now = System.currentTimeMillis();
        this.expirationTime = maxLifetime > 0L ? now + maxLifetime : Long.MAX_VALUE;
        this.lastAccess = now;
        this.openStatements = new FastList(Statement.class);
        this.hashCode = System.identityHashCode(this);
        this.isCatalogDirty = true;
        this.isReadOnlyDirty = defaultReadOnly;
        this.isAutoCommitDirty = true;
        this.isTransactionIsolationDirty = true;
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public final void captureStack(long leakDetectionThreshold, Timer scheduler) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StackTraceElement[] leakTrace = new StackTraceElement[trace.length - 4];
        System.arraycopy(trace, 4, leakTrace, 0, leakTrace.length);
        this.leakTask = new LeakTask(leakTrace, leakDetectionThreshold);
        scheduler.schedule(this.leakTask, leakDetectionThreshold);
    }

    @Override
    public final void checkException(SQLException sqle) {
        String sqlState = sqle.getSQLState();
        if (sqlState != null) {
            this.forceClose |= sqlState.startsWith("08") | SQL_ERRORS.contains(sqlState);
            if (this.forceClose) {
                LOGGER.warn(String.format("Connection %s (%s) marked as broken because of SQLSTATE(%s), ErrorCode(%d).", this.delegate.toString(), this.parentPool.toString(), sqlState, sqle.getErrorCode()), (Throwable)sqle);
            } else if (sqle.getNextException() instanceof SQLException) {
                this.checkException(sqle.getNextException());
            }
        }
    }

    @Override
    public final long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public final long getLastAccess() {
        return this.lastAccess;
    }

    @Override
    public long getLastOpenTime() {
        return this.uncloseTime;
    }

    @Override
    public final boolean isBrokenConnection() {
        return this.forceClose;
    }

    @Override
    public final void realClose() throws SQLException {
        this.delegate.close();
    }

    @Override
    public final void resetConnectionState() throws SQLException {
        if (!this.delegate.getAutoCommit()) {
            this.delegate.rollback();
        }
        if (this.isReadOnlyDirty) {
            this.delegate.setReadOnly(this.defaultReadOnly);
            this.isReadOnlyDirty = false;
        }
        if (this.isAutoCommitDirty) {
            this.delegate.setAutoCommit(this.defaultAutoCommit);
            this.isAutoCommitDirty = false;
        }
        if (this.isTransactionIsolationDirty) {
            this.delegate.setTransactionIsolation(this.defaultIsolationLevel);
            this.isTransactionIsolationDirty = false;
        }
        if (this.isCatalogDirty && this.defaultCatalog != null) {
            this.delegate.setCatalog(this.defaultCatalog);
            this.isCatalogDirty = false;
        }
        this.delegate.clearWarnings();
    }

    @Override
    public final void unclose(long now) {
        this.isClosed = false;
        this.uncloseTime = now;
    }

    @Override
    public final void untrackStatement(Statement statement) {
        if (!this.isClosed) {
            this.openStatements.remove(statement);
        }
    }

    protected final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    private <T extends Statement> T trackStatement(T statement) {
        this.openStatements.add(statement);
        return statement;
    }

    @Override
    public final int getState() {
        return this.state.get();
    }

    @Override
    public final boolean compareAndSetState(int expectedState, int newState) {
        return this.state.compareAndSet(expectedState, newState);
    }

    @Override
    public final void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.leakTask != null) {
                this.leakTask.cancel();
                this.leakTask = null;
            }
            try {
                int size = this.openStatements.size();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        try {
                            this.openStatements.get(i).close();
                            continue;
                        }
                        catch (SQLException e) {
                            this.checkException(e);
                        }
                    }
                    this.openStatements.clear();
                }
                this.resetConnectionState();
            }
            catch (SQLException e) {
                this.checkException(e);
                throw e;
            }
            finally {
                this.lastAccess = System.currentTimeMillis();
                this.parentPool.releaseConnection(this, this.forceClose);
            }
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public final Statement createStatement() throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement());
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency));
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement proxyCallableStatement = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql));
            return this.trackStatement(proxyCallableStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement proxyCallableStatement = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency));
            return this.trackStatement(proxyCallableStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement proxyCallableStatement = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            return this.trackStatement(proxyCallableStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, autoGeneratedKeys));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnIndexes));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnNames));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final boolean isValid(int timeout) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        try {
            return this.delegate.isValid(timeout);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setAutoCommit(autoCommit);
            this.isAutoCommitDirty = autoCommit != this.defaultAutoCommit;
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setReadOnly(readOnly);
            this.isReadOnlyDirty = readOnly != this.defaultReadOnly;
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setTransactionIsolation(level);
            this.isTransactionIsolationDirty = level != this.defaultIsolationLevel;
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setCatalog(catalog);
            this.isCatalogDirty = !catalog.equals(this.defaultCatalog);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.delegate);
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        throw new SQLException("Wrapped connection is not an instance of " + iface);
    }

    static {
        SQL_ERRORS.add("57P01");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("57P03");
        SQL_ERRORS.add("01002");
        SQL_ERRORS.add("JZ0C0");
        SQL_ERRORS.add("JZ0C1");
    }
}

