/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.impl;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.pentaho.caching.api.PentahoCacheManager;
import org.pentaho.caching.api.PentahoCacheProvidingService;
import org.pentaho.caching.api.PentahoCacheSystemConfiguration;
import org.pentaho.caching.api.PentahoCacheTemplateConfiguration;

public class PentahoCacheManagerImpl
implements PentahoCacheManager {
    private final PentahoCacheSystemConfiguration systemConfiguration;
    private final PentahoCacheProvidingService service;
    private final CacheManager cacheManager;

    public PentahoCacheManagerImpl(PentahoCacheSystemConfiguration systemConfiguration, PentahoCacheProvidingService service) {
        this.systemConfiguration = systemConfiguration;
        this.service = service;
        this.cacheManager = service.createCacheManager(systemConfiguration);
    }

    private CacheManager delegate() {
        return this.cacheManager;
    }

    public CachingProvider getCachingProvider() {
        return this.delegate().getCachingProvider();
    }

    public URI getURI() {
        return this.delegate().getURI();
    }

    public ClassLoader getClassLoader() {
        return this.delegate().getClassLoader();
    }

    public Properties getProperties() {
        return this.delegate().getProperties();
    }

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        return this.delegate().createCache(cacheName, configuration);
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        return this.delegate().getCache(cacheName, keyType, valueType);
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.delegate().getCache(cacheName);
    }

    public Iterable<String> getCacheNames() {
        return this.delegate().getCacheNames();
    }

    public void destroyCache(String cacheName) {
        this.delegate().destroyCache(cacheName);
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.delegate().enableManagement(cacheName, enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.delegate().enableStatistics(cacheName, enabled);
    }

    public void close() {
        this.delegate().close();
    }

    public boolean isClosed() {
        return this.delegate().isClosed();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        return (T)this.delegate().unwrap(clazz);
    }

    @Override
    public PentahoCacheSystemConfiguration getSystemConfiguration() {
        return this.systemConfiguration;
    }

    @Override
    public PentahoCacheProvidingService getService() {
        return this.service;
    }

    @Override
    public <K, V> Configuration<K, V> createConfiguration(Class<K> keyType, Class<V> valueType, Map<String, String> properties) {
        return this.service.createConfiguration(keyType, valueType, properties);
    }

    @Override
    public Map<String, PentahoCacheTemplateConfiguration> getTemplates() {
        return this.systemConfiguration.createTemplates(this);
    }
}

