/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.spi;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Longs;
import java.util.Map;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.MutableConfiguration;
import org.pentaho.caching.api.Constants;
import org.pentaho.caching.api.PentahoCacheProvidingService;

public abstract class AbstractCacheProvidingService
implements PentahoCacheProvidingService {
    public <K, V> CompleteConfiguration<K, V> createConfiguration(Class<K> keyType, Class<V> valueType, Map<String, String> properties) {
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(keyType, valueType);
        if (properties.containsKey("ttl")) {
            Long ttl = Longs.tryParse((String)Strings.nullToEmpty((String)properties.get("ttl")));
            Preconditions.checkArgument((ttl != null ? 1 : 0) != 0, (String)"Template config error", (Object[])new Object[]{"ttl"});
            Optional expiryFunction = properties.containsKey("ttl.resetOn") ? Enums.getIfPresent(Constants.ExpiryFunction.class, (String)properties.get("ttl.resetOn")) : Optional.of((Object)((Object)Constants.CONFIG_TTL_RESET_DEFAULT));
            Preconditions.checkArgument((boolean)expiryFunction.isPresent(), (String)"Template config error", (Object[])new Object[]{"ttl.resetOn"});
            configuration.setExpiryPolicyFactory(((Constants.ExpiryFunction)((Object)expiryFunction.get())).createFactory(ttl));
        }
        if (properties.containsKey("storeByValue")) {
            configuration.setStoreByValue(Boolean.valueOf(properties.get("storeByValue")).booleanValue());
        }
        return configuration;
    }
}

