/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.olap.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.metadata.model.olap.OlapCalculatedMember;
import org.pentaho.metadata.model.olap.OlapRole;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OlapUtil {
    public static String toXmlCalculatedMembers(List<OlapCalculatedMember> members) {
        StringBuffer xml = new StringBuffer();
        xml.append("<calculatedMembers>");
        for (OlapCalculatedMember member : members) {
            xml.append(OlapUtil.calculatedMemberToXml(member));
        }
        xml.append("</calculatedMembers>");
        return xml.toString();
    }

    public static Map<String, List<OlapCalculatedMember>> fromXmlCalculatedMembers(String xml) throws Exception {
        HashMap<String, List<OlapCalculatedMember>> cubeMembers = new HashMap<String, List<OlapCalculatedMember>>();
        Document doc = XMLHandler.loadXMLString((String)xml);
        Node cubesNode = XMLHandler.getSubNode((Node)doc, (String)"cubes");
        int numCubes = XMLHandler.countNodes((Node)cubesNode, (String)"cube");
        for (int i = 0; i < numCubes; ++i) {
            Node cubeNode = XMLHandler.getSubNodeByNr((Node)cubesNode, (String)"cube", (int)i);
            Node membersNode = XMLHandler.getSubNode((Node)cubeNode, (String)"calculatedMembers");
            int numMembers = XMLHandler.countNodes((Node)membersNode, (String)"calculatedMember");
            ArrayList<OlapCalculatedMember> members = new ArrayList<OlapCalculatedMember>();
            for (int j = 0; j < numMembers; ++j) {
                Node memberNode = XMLHandler.getSubNodeByNr((Node)membersNode, (String)"calculatedMember", (int)j);
                members.add(new OlapCalculatedMember(XMLHandler.getTagValue((Node)memberNode, (String)"name"), XMLHandler.getTagValue((Node)memberNode, (String)"dimension"), XMLHandler.getTagValue((Node)memberNode, (String)"formula"), XMLHandler.getTagValue((Node)memberNode, (String)"formatString"), "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)memberNode, (String)"calculateSubtotals")), "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)memberNode, (String)"hidden"))));
            }
            cubeMembers.put(XMLHandler.getTagValue((Node)cubeNode, (String)"name"), members);
        }
        return cubeMembers;
    }

    public static String toXmlRoles(List<OlapRole> roles) {
        StringBuffer xml = new StringBuffer();
        xml.append("<roles>");
        for (OlapRole role : roles) {
            xml.append(OlapUtil.olapRoleToXml(role));
        }
        xml.append("</roles>");
        return xml.toString();
    }

    public static List<OlapRole> fromXmlRoles(String xml) throws Exception {
        ArrayList<OlapRole> roles = new ArrayList<OlapRole>();
        Document doc = XMLHandler.loadXMLString((String)xml);
        Node rolesNode = XMLHandler.getSubNode((Node)doc, (String)"roles");
        int num = XMLHandler.countNodes((Node)rolesNode, (String)"role");
        for (int i = 0; i < num; ++i) {
            Node roleNode = XMLHandler.getSubNodeByNr((Node)rolesNode, (String)"role", (int)i);
            roles.add(OlapUtil.olapRoleFromNode(roleNode));
        }
        return roles;
    }

    public static OlapRole olapRoleFromNode(Node node) throws KettleXMLException {
        String name = XMLHandler.getTagValue((Node)node, (String)"name");
        StringBuilder xml = new StringBuilder();
        NodeList children = XMLHandler.getSubNode((Node)node, (String)"definition").getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            xml.append(XMLHandler.formatNode((Node)children.item(i)));
        }
        String definition = xml.toString();
        return new OlapRole(name, definition);
    }

    public static String calculatedMemberToXml(OlapCalculatedMember member) {
        StringBuilder xml = new StringBuilder();
        xml.append("<calculatedMember>");
        xml.append(XMLHandler.addTagValue((String)"name", (String)member.getName(), (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"dimension", (String)member.getDimension(), (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"formula", (String)member.getFormula(), (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"formatString", (String)member.getFormatString(), (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"calculateSubtotals", (boolean)member.isCalculateSubtotals(), (boolean)false));
        xml.append(XMLHandler.addTagValue((String)"hidden", (boolean)member.isHidden()));
        xml.append("</calculatedMember>");
        return xml.toString();
    }

    public static String olapRoleToXml(OlapRole role) {
        StringBuilder xml = new StringBuilder();
        xml.append("<role>");
        xml.append(XMLHandler.addTagValue((String)"name", (String)role.getName(), (boolean)false, (String[])new String[0]));
        xml.append("<definition>");
        xml.append(role.getDefinition());
        xml.append("</definition>");
        xml.append("</role>");
        return xml.toString();
    }
}

