/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.automodel;

import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.automodel.PhysicalTableImporter;
import org.pentaho.pms.automodel.SchemaTable;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.PhysicalColumn;
import org.pentaho.pms.schema.PhysicalTable;
import org.pentaho.pms.schema.SchemaMeta;
import org.pentaho.pms.util.Const;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.Settings;

public class AutoModeler {
    private DatabaseMeta databaseMeta;
    private SchemaTable[] tableNames;
    private String modelName;
    private String locale;

    public AutoModeler(String locale, String modelName, DatabaseMeta databaseMeta, SchemaTable[] tableNames) {
        this.locale = locale;
        this.modelName = modelName;
        this.databaseMeta = databaseMeta;
        this.tableNames = tableNames;
    }

    public SchemaMeta generateSchemaMeta() throws PentahoMetadataException {
        SchemaMeta schemaMeta = new SchemaMeta();
        schemaMeta.setName(this.modelName);
        Database database = new Database(this.databaseMeta);
        try {
            schemaMeta.addDatabase(this.databaseMeta);
            String bmID = Settings.getBusinessModelIDPrefix() + "_" + Const.replace(this.modelName, " ", "_").toUpperCase();
            BusinessModel businessModel = new BusinessModel(bmID);
            schemaMeta.addModel(businessModel);
            database.connect();
            DBCache.getInstance().clear(this.databaseMeta.getName());
            for (int i = 0; i < this.tableNames.length; ++i) {
                SchemaTable schemaTable = this.tableNames[i];
                PhysicalTable physicalTable = PhysicalTableImporter.importTableDefinition(database, schemaTable.getSchemaName(), schemaTable.getTableName(), this.locale);
                schemaMeta.addTable(physicalTable);
                BusinessTable businessTable = this.createBusinessTable(physicalTable, this.locale);
                businessModel.addBusinessTable(businessTable);
            }
            schemaMeta.setActiveModel(businessModel);
        }
        catch (Exception e) {
            throw new PentahoMetadataException(e);
        }
        finally {
            database.disconnect();
        }
        return schemaMeta;
    }

    private BusinessColumn findBusinessColumn(BusinessTable businessTable, String columnName) {
        for (int i = 0; i < businessTable.nrBusinessColumns(); ++i) {
            BusinessColumn businessColumn = businessTable.getBusinessColumn(i);
            if (!columnName.equals(businessColumn.getPhysicalColumn().getFormula())) continue;
            return businessColumn;
        }
        return null;
    }

    private BusinessTable createBusinessTable(PhysicalTable physicalTable, String locale) throws ObjectAlreadyExistsException {
        BusinessTable businessTable = new BusinessTable(null, physicalTable);
        String tableName = PhysicalTableImporter.beautifyName(physicalTable.getTargetTable());
        businessTable.getConcept().setName(locale, tableName);
        businessTable.setId(BusinessTable.proposeId(locale, businessTable, physicalTable));
        for (int i = 0; i < physicalTable.nrPhysicalColumns(); ++i) {
            PhysicalColumn physicalColumn = physicalTable.getPhysicalColumn(i);
            BusinessColumn businessColumn = new BusinessColumn(physicalColumn.getId(), physicalColumn, businessTable);
            businessColumn.setId(BusinessColumn.proposeId(locale, businessTable, physicalColumn));
            businessTable.addBusinessColumn(businessColumn);
        }
        return businessTable;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public SchemaTable[] getTableNames() {
        return this.tableNames;
    }

    public void setTableNames(SchemaTable[] tableNames) {
        this.tableNames = tableNames;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

