/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql;

import java.util.Calendar;
import java.util.StringTokenizer;

public class DateMath {
    private static final char POSITION_END = 'E';
    private static final char POSITION_START = 'S';
    private static final char UNIT_YEAR = 'Y';
    private static final char UNIT_MONTH = 'M';
    private static final char UNIT_WEEK = 'W';
    private static final char UNIT_DAY = 'D';
    private static final char UNIT_HOUR = 'h';
    private static final char UNIT_MINUTE = 'm';
    private static final char UNIT_SECOND = 's';

    public static Calendar calculateDate(String expression) {
        return DateMath.calculateDate(null, expression);
    }

    public static Calendar calculateDate(Calendar date, String expression) {
        Calendar target = date;
        int index = expression.indexOf(59);
        String myExpression = index >= 0 ? expression.substring(index + 1) : expression;
        StringTokenizer tok = new StringTokenizer(myExpression, " \t;");
        while (tok.hasMoreElements()) {
            target = DateMath.parseAndCalculateDate(target, (String)tok.nextElement());
        }
        return target;
    }

    private static Calendar parseAndCalculateDate(Calendar date, String expression) {
        Calendar result;
        int index = expression.indexOf(58);
        char operation = '+';
        char unit = ' ';
        char position = ' ';
        int operand = 0;
        if (index >= 0) {
            try {
                String number = expression.substring(0, index);
                operation = number.charAt(0);
                if (operation == '+' || operation == '-') {
                    number = number.substring(1);
                } else {
                    operation = '+';
                }
                operand = Integer.parseInt(number);
                unit = expression.charAt(++index);
                if (++index < expression.length()) {
                    position = expression.charAt(index);
                }
                result = DateMath.calculateDate(date, operation, operand, unit, position);
            }
            catch (Exception ex) {
                IllegalArgumentException err = new IllegalArgumentException(expression);
                err.initCause(ex);
                throw err;
            }
        } else {
            throw new IllegalArgumentException(expression);
        }
        return result;
    }

    private static Calendar calculateDate(Calendar date, char operation, int operand, char unit, char position) {
        Calendar target = date == null ? Calendar.getInstance() : date;
        int calendarField = -1;
        switch (unit) {
            case 'Y': {
                calendarField = 1;
                break;
            }
            case 'M': {
                calendarField = 2;
                break;
            }
            case 'W': {
                calendarField = 6;
                operand *= 7;
                break;
            }
            case 'D': {
                calendarField = 6;
                break;
            }
            case 'h': {
                calendarField = 11;
                break;
            }
            case 'm': {
                calendarField = 12;
                break;
            }
            case 's': {
                calendarField = 13;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (operation == ' ') {
            target.set(calendarField, operand);
        } else if (operation == '+') {
            target.add(calendarField, operand);
        } else if (operation == '-') {
            target.add(calendarField, -Math.abs(operand));
        }
        if (unit == 'Y') {
            if (position == 'S') {
                target.set(6, 1);
                DateMath.setTimeToStart(target);
            } else if (position == 'E') {
                target.set(6, target.getActualMaximum(6));
                DateMath.setTimeToEnd(target);
            }
        } else if (unit == 'M') {
            if (position == 'S') {
                target.set(5, 1);
                DateMath.setTimeToStart(target);
            } else if (position == 'E') {
                target.set(5, target.getActualMaximum(5));
                DateMath.setTimeToEnd(target);
            }
        } else if (unit == 'W') {
            int firstDOW = target.getFirstDayOfWeek();
            int dayOfWeek = target.get(7);
            int dayOffset = 0;
            if (position == 'S') {
                if (dayOfWeek > firstDOW) {
                    dayOffset = firstDOW - dayOfWeek;
                } else if (dayOfWeek < firstDOW) {
                    dayOffset = -7 + (firstDOW - dayOfWeek);
                }
                DateMath.setTimeToStart(target);
            } else if (position == 'E') {
                int lastDOW = firstDOW == 1 ? 7 : firstDOW - 1;
                if (dayOfWeek < lastDOW) {
                    dayOffset = lastDOW - dayOfWeek;
                } else if (dayOfWeek > lastDOW) {
                    dayOffset = 7 - (dayOfWeek - lastDOW);
                }
                DateMath.setTimeToEnd(target);
            }
            if (dayOffset != 0) {
                target.add(6, dayOffset);
            }
        } else if (unit == 'D') {
            if (position == 'S') {
                DateMath.setTimeToStart(target);
            } else if (position == 'E') {
                DateMath.setTimeToEnd(target);
            }
        } else if (unit == 'h') {
            if (position == 'S') {
                target.set(12, 0);
                target.set(13, 0);
                target.set(14, 0);
            } else if (position == 'E') {
                target.set(12, 59);
                target.set(13, 59);
                target.set(14, 999);
            }
        } else if (unit == 'm') {
            if (position == 'S') {
                target.set(13, 0);
                target.set(14, 0);
            } else if (position == 'E') {
                target.set(13, 59);
                target.set(14, 999);
            }
        } else if (unit == 's') {
            if (position == 'S') {
                target.set(14, 0);
            } else if (position == 'E') {
                target.set(14, 999);
            }
        }
        target.getTimeInMillis();
        return target;
    }

    private static void setTimeToStart(Calendar target) {
        target.set(14, 0);
        target.set(13, 0);
        target.set(12, 0);
        target.set(11, 0);
    }

    private static void setTimeToEnd(Calendar target) {
        target.set(14, 999);
        target.set(13, 59);
        target.set(12, 59);
        target.set(11, 23);
    }
}

