/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.pms.core.CWM;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.factory.CwmSchemaFactoryInterface;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.MQLQuery;
import org.pentaho.pms.mql.MappedQuery;
import org.pentaho.pms.mql.OrderBy;
import org.pentaho.pms.mql.SQLGenerator;
import org.pentaho.pms.mql.Selection;
import org.pentaho.pms.mql.WhereCondition;
import org.pentaho.pms.schema.BusinessCategory;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.SchemaMeta;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.util.Settings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MQLQueryImpl
implements MQLQuery {
    private static final Log logger = LogFactory.getLog(MQLQuery.class);
    public static int DOMAIN_TYPE_RELATIONAL = 1;
    public static int DOMAIN_TYPE_OLAP = 2;
    private int domainType = DOMAIN_TYPE_RELATIONAL;
    private List<Selection> selections = new ArrayList<Selection>();
    private List<WhereCondition> constraints = new ArrayList<WhereCondition>();
    private List<OrderBy> order = new ArrayList<OrderBy>();
    private BusinessModel model;
    private String locale;
    private SchemaMeta schemaMeta;
    private boolean disableDistinct;
    private int limit = -1;
    private CwmSchemaFactoryInterface cwmSchemaFactory;
    private SQLGenerator sqlGenerator = new SQLGenerator();
    private DatabaseMeta databaseMeta = null;

    public MQLQueryImpl(SchemaMeta schemaMeta, BusinessModel model, DatabaseMeta databaseMeta, String locale) {
        this.databaseMeta = databaseMeta;
        this.schemaMeta = schemaMeta;
        this.model = model;
        this.locale = locale;
    }

    public MQLQueryImpl(String XML, DatabaseMeta databaseMeta, String locale, CwmSchemaFactoryInterface factory) throws PentahoMetadataException {
        this.databaseMeta = databaseMeta;
        this.locale = locale;
        this.cwmSchemaFactory = factory;
        this.fromXML(XML);
    }

    public void addSelection(Selection selection) {
        if (!this.selections.contains(selection)) {
            this.selections.add(selection);
        }
    }

    @Override
    public List<Selection> getSelections() {
        return this.selections;
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        if (this.databaseMeta == null && this.selections.size() > 0) {
            return this.selections.get(0).getBusinessColumn().getPhysicalColumn().getTable().getDatabaseMeta();
        }
        return this.databaseMeta;
    }

    public void addConstraint(String operator, String condition) throws PentahoMetadataException {
        WhereCondition where = new WhereCondition(this.model, this.getDatabaseMeta(), operator, condition);
        this.constraints.add(where);
    }

    public void addOrderBy(String categoryId, String columnId, String aggregation, boolean ascending) throws PentahoMetadataException {
        BusinessCategory rootCat = this.model.getRootCategory();
        BusinessCategory businessCategory = rootCat.findBusinessCategory(categoryId);
        if (businessCategory == null) {
            throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0014_BUSINESS_CATEGORY_NOT_FOUND", categoryId));
        }
        this.addOrderBy(businessCategory, columnId, aggregation, ascending);
    }

    public void addOrderBy(BusinessCategory businessCategory, String columnId, String aggregation, boolean ascending) throws PentahoMetadataException {
        if (businessCategory == null) {
            throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0015_BUSINESS_CATEGORY_NULL"));
        }
        BusinessColumn businessColumn = businessCategory.findBusinessColumn(columnId);
        if (businessColumn == null) {
            throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0016_BUSINESS_COLUMN_NOT_FOUND", businessCategory.getId(), columnId));
        }
        AggregationSettings aggsetting = null;
        if (aggregation != null) {
            AggregationSettings setting = AggregationSettings.getType(aggregation);
            if (businessColumn.getAggregationType() == setting || businessColumn.getAggregationList() != null && businessColumn.getAggregationList().contains(setting)) {
                aggsetting = setting;
            }
        }
        OrderBy orderBy = new OrderBy(new Selection(businessColumn, aggsetting), ascending);
        this.order.add(orderBy);
    }

    @Override
    public MappedQuery getQuery() throws PentahoMetadataException {
        String mqlSecurityConstraint;
        if (this.model == null || this.selections.size() == 0) {
            return null;
        }
        WhereCondition securityConstraint = null;
        if (this.cwmSchemaFactory != null && StringUtils.isNotBlank((String)(mqlSecurityConstraint = this.cwmSchemaFactory.generateRowLevelSecurityConstraint(this.model)))) {
            securityConstraint = new WhereCondition(this.model, this.getDatabaseMeta(), "AND", mqlSecurityConstraint);
        }
        return this.sqlGenerator.getSQL(this.model, this.selections, this.constraints, this.order, this.getDatabaseMeta(), this.locale, this.disableDistinct, this.limit, securityConstraint);
    }

    @Override
    public String getXML() {
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult();
            result.setWriter(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Document doc = this.getDocument();
            if (doc != null) {
                factory.newTransformer().transform(new DOMSource(doc), result);
                return stringWriter.getBuffer().toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("MQLQuery.ERROR_0013_GET_XML_FAILED"), (Throwable)e);
        }
        return null;
    }

    public Document getDocument() {
        try {
            DocumentBuilderFactory dbf = XmiParser.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element mqlElement = doc.createElement("mql");
            doc.appendChild(mqlElement);
            if (this.addToDocument(mqlElement, doc)) {
                return doc;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("MQLQuery.ERROR_0012_GET_DOCUMENT_FAILED"), (Throwable)e);
            return null;
        }
    }

    public boolean addToDocument(Element mqlElement, Document doc) {
        try {
            if (this.schemaMeta == null) {
                logger.error((Object)Messages.getErrorString("MQLQuery.ERROR_0002_META_SCHEMA_NULL"));
                return false;
            }
            if (this.model == null) {
                logger.error((Object)Messages.getErrorString("MQLQuery.ERROR_0003_BUSINESS_MODEL_NULL"));
                return false;
            }
            Element typeElement = doc.createElement("domain_type");
            typeElement.appendChild(doc.createTextNode(this.domainType == DOMAIN_TYPE_RELATIONAL ? "relational" : "olap"));
            mqlElement.appendChild(typeElement);
            String data = this.schemaMeta.getDomainName();
            if (data == null) {
                logger.error((Object)Messages.getErrorString("MQLQuery.ERROR_0004_DOMAIN_ID_NULL"));
                return false;
            }
            Element domainIdElement = doc.createElement("domain_id");
            domainIdElement.appendChild(doc.createTextNode(data));
            mqlElement.appendChild(domainIdElement);
            data = this.model.getId();
            if (data == null) {
                logger.error((Object)Messages.getErrorString("MQLQuery.ERROR_0005_MODEL_ID_NULL"));
                return false;
            }
            Element modelIdElement = doc.createElement("model_id");
            modelIdElement.appendChild(doc.createTextNode(data));
            mqlElement.appendChild(modelIdElement);
            data = this.model.getDisplayName(this.locale);
            if (data == null) {
                logger.error((Object)Messages.getErrorString("MQLQuery.ERROR_0006_MODEL_NAME_NULL"));
                return false;
            }
            Element modelNameElement = doc.createElement("model_name");
            modelNameElement.appendChild(doc.createTextNode(data));
            mqlElement.appendChild(modelNameElement);
            Element optionsElement = doc.createElement("options");
            mqlElement.appendChild(optionsElement);
            this.addOptionsToDocument(doc, optionsElement);
            Element selectionsElement = doc.createElement("selections");
            for (Selection selection : this.selections) {
                Element selectionElement = doc.createElement("selection");
                this.addSelectionToDocument(doc, selection, selectionElement);
                selectionsElement.appendChild(selectionElement);
            }
            mqlElement.appendChild(selectionsElement);
            Element constraintsElement = doc.createElement("constraints");
            for (WhereCondition condition : this.constraints) {
                Element constraintElement = doc.createElement("constraint");
                this.addConstraintToDocument(doc, condition, constraintElement);
                constraintsElement.appendChild(constraintElement);
            }
            mqlElement.appendChild(constraintsElement);
            Element element = doc.createElement("orders");
            for (OrderBy orderBy : this.order) {
                Element orderElement = doc.createElement("order");
                this.addOrderByToDocument(doc, orderBy, orderElement);
                element.appendChild(orderElement);
            }
            mqlElement.appendChild(element);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("MQLQuery.ERROR_0011_ADD_TO_DOCUMENT_FAILED"), (Throwable)e);
        }
        return true;
    }

    protected void addOptionsToDocument(Document doc, Element optionsElement) {
        Element disableDistinct = doc.createElement("disable_distinct");
        String data = Boolean.toString(this.disableDistinct);
        disableDistinct.appendChild(doc.createTextNode(data));
        optionsElement.appendChild(disableDistinct);
        Element limit = doc.createElement("limit");
        String limitData = String.valueOf(this.limit);
        limit.appendChild(doc.createTextNode(limitData));
        optionsElement.appendChild(limit);
    }

    protected void addSelectionToDocument(Document doc, Selection selection, Element selectionElement) {
        BusinessColumn column = selection.getBusinessColumn();
        Element element = doc.createElement("view");
        BusinessCategory rootCat = this.model.getRootCategory();
        BusinessCategory businessCategory = rootCat.findBusinessCategoryForBusinessColumn(column);
        element.appendChild(doc.createTextNode(businessCategory.getId()));
        selectionElement.appendChild(element);
        element = doc.createElement("column");
        element.appendChild(doc.createTextNode(column.getId()));
        selectionElement.appendChild(element);
        if (selection.getAggregationType() != null) {
            element = doc.createElement("aggregation");
            element.appendChild(doc.createTextNode(selection.getAggregationType().getCode()));
            selectionElement.appendChild(element);
        }
    }

    protected void addConstraintToDocument(Document doc, WhereCondition condition, Element constraintElement) {
        Element element = doc.createElement("operator");
        element.appendChild(doc.createTextNode(condition.getOperator() == null ? "" : condition.getOperator()));
        constraintElement.appendChild(element);
        element = doc.createElement("condition");
        element.appendChild(doc.createTextNode(condition.getCondition()));
        constraintElement.appendChild(element);
    }

    protected void addOrderByToDocument(Document doc, OrderBy orderBy, Element orderElement) {
        Element element = doc.createElement("direction");
        element.appendChild(doc.createTextNode(orderBy.isAscending() ? "asc" : "desc"));
        orderElement.appendChild(element);
        element = doc.createElement("view_id");
        BusinessCategory rootCat = this.model.getRootCategory();
        BusinessCategory businessView = rootCat.findBusinessCategoryForBusinessColumn(orderBy.getSelection().getBusinessColumn());
        element.appendChild(doc.createTextNode(businessView.getId()));
        orderElement.appendChild(element);
        element = doc.createElement("column_id");
        element.appendChild(doc.createTextNode(orderBy.getSelection().getBusinessColumn().getId()));
        orderElement.appendChild(element);
        if (orderBy.getSelection().getAggregationType() != null) {
            element = doc.createElement("aggregation");
            element.appendChild(doc.createTextNode(orderBy.getSelection().getAggregationType().getCode()));
            orderElement.appendChild(element);
        }
    }

    public void fromXML(String XML) throws PentahoMetadataException {
        Document doc;
        if (XML == null) {
            throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0017_XML_NULL"));
        }
        try {
            DocumentBuilderFactory dbf = XmiParser.createSecureDocBuilderFactory();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(new StringReader(XML)));
        }
        catch (ParserConfigurationException pcx) {
            throw new PentahoMetadataException(pcx);
        }
        catch (SAXException sex) {
            throw new PentahoMetadataException(sex);
        }
        catch (IOException iex) {
            throw new PentahoMetadataException(iex);
        }
        this.fromXML(doc);
    }

    public void fromXML(String XML, SchemaMeta localSchemaMeta) throws PentahoMetadataException {
        Document doc;
        if (XML == null) {
            throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0017_XML_NULL"));
        }
        try {
            DocumentBuilderFactory dbf = XmiParser.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new InputSource(new StringReader(XML)));
        }
        catch (ParserConfigurationException pcx) {
            throw new PentahoMetadataException(pcx);
        }
        catch (SAXException sex) {
            throw new PentahoMetadataException(sex);
        }
        catch (IOException iex) {
            throw new PentahoMetadataException(iex);
        }
        this.fromXML(doc, localSchemaMeta);
    }

    public void fromXML(Document doc) throws PentahoMetadataException {
        String domainTypeStr = this.getElementText(doc, "domain_type");
        if ("relational".equals(domainTypeStr)) {
            this.domainType = DOMAIN_TYPE_RELATIONAL;
        } else if ("olap".equals(domainTypeStr)) {
            this.domainType = DOMAIN_TYPE_OLAP;
        } else {
            throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0007_INVALID_DOMAIN_TYPE", domainTypeStr));
        }
        String domainId = this.getElementText(doc, "domain_id");
        CWM cwm = CWM.getInstance(domainId);
        if (cwm == null) {
            throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0008_CWM_DOMAIN_INSTANCE_NULL", domainId));
        }
        if (this.cwmSchemaFactory == null) {
            this.cwmSchemaFactory = Settings.getCwmSchemaFactory();
        }
        this.fromXML(doc, this.cwmSchemaFactory.getSchemaMeta(cwm));
    }

    public void fromXML(Document doc, SchemaMeta localSchemaMeta) throws PentahoMetadataException {
        this.schemaMeta = localSchemaMeta;
        String modelId = this.getElementText(doc, "model_id");
        this.model = localSchemaMeta.findModel(modelId);
        if (this.model == null) {
            throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0009_MODEL_NOT_FOUND", modelId));
        }
        NodeList nList = doc.getElementsByTagName("options");
        if (nList != null) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Element optionElement = (Element)nList.item(i);
                this.setOptionsFromXmlNode(optionElement);
            }
        }
        NodeList nodes = doc.getElementsByTagName("selection");
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element selectionElement = (Element)nodes.item(idx);
            this.addSelectionFromXmlNode(selectionElement);
        }
        nodes = doc.getElementsByTagName("constraint");
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element constraintElement = (Element)nodes.item(idx);
            this.addConstraintFromXmlNode(constraintElement);
        }
        nodes = doc.getElementsByTagName("order");
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element orderElement = (Element)nodes.item(idx);
            this.addOrderByFromXmlNode(orderElement);
        }
    }

    protected void addSelectionFromXmlNode(Element selectionElement) {
        NodeList nodes = selectionElement.getElementsByTagName("column");
        if (nodes.getLength() > 0) {
            String columnId = XMLHandler.getNodeValue((Node)nodes.item(0));
            BusinessColumn businessColumn = this.getModel().findBusinessColumn(columnId);
            if (businessColumn != null) {
                AggregationSettings aggsetting = null;
                NodeList aggnodes = selectionElement.getElementsByTagName("aggregation");
                if (aggnodes.getLength() > 0) {
                    String aggvalue = XMLHandler.getNodeValue((Node)aggnodes.item(0));
                    AggregationSettings setting = AggregationSettings.getType(aggvalue);
                    if (setting == null) {
                        Messages.getErrorString("MQLQuery.ERROR_0018_AGG_NOT_RECOGNIZED", columnId, aggvalue);
                    } else if (businessColumn.getAggregationType() == setting || businessColumn.getAggregationList() != null && businessColumn.getAggregationList().contains(setting)) {
                        aggsetting = setting;
                    } else {
                        Messages.getErrorString("MQLQuery.ERROR_0019_INVALID_AGG_FOR_BUSINESS_COL", columnId, aggvalue);
                    }
                }
                this.addSelection(new Selection(businessColumn, aggsetting));
            } else {
                Messages.getErrorString("MQLQuery.ERROR_0020_BUSINESS_COL_NOT_FOUND", columnId);
            }
        }
    }

    protected void setOptionsFromXmlNode(Element optionElement) throws PentahoMetadataException {
        this.disableDistinct = false;
        this.limit = -1;
        if (optionElement != null) {
            String limitStr;
            String disableStr = this.getElementText(optionElement, "disable_distinct");
            if (disableStr != null) {
                this.disableDistinct = disableStr.equalsIgnoreCase("true");
            }
            if ((limitStr = this.getElementText(optionElement, "limit")) != null) {
                try {
                    this.limit = Integer.parseInt(limitStr);
                }
                catch (NumberFormatException e) {
                    throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0021_CANNOT_PARSE_LIMIT"));
                }
            }
        }
    }

    protected void addOrderByFromXmlNode(Element orderElement) throws PentahoMetadataException {
        boolean ascending = true;
        String view_id = null;
        String column_id = null;
        String aggregation = null;
        NodeList nodes = orderElement.getElementsByTagName("direction");
        if (nodes.getLength() > 0) {
            ascending = XMLHandler.getNodeValue((Node)nodes.item(0)).equals("asc");
        }
        if ((nodes = orderElement.getElementsByTagName("view_id")).getLength() > 0) {
            view_id = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("column_id")).getLength() > 0) {
            column_id = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("aggregation")).getLength() > 0) {
            aggregation = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if (view_id != null && column_id != null) {
            this.addOrderBy(view_id, column_id, aggregation, ascending);
        }
    }

    protected void addConstraintFromXmlNode(Element constraintElement) throws PentahoMetadataException {
        NodeList nodes = constraintElement.getElementsByTagName("operator");
        String operator = null;
        if (nodes.getLength() > 0) {
            operator = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        nodes = constraintElement.getElementsByTagName("condition");
        String cond = null;
        if (nodes.getLength() > 0) {
            cond = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        nodes = constraintElement.getElementsByTagName("view_id");
        String view_id = null;
        if (nodes.getLength() > 0) {
            view_id = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        nodes = constraintElement.getElementsByTagName("column_id");
        String column_id = null;
        if (nodes.getLength() > 0) {
            column_id = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if (cond == null) {
            throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0001_NULL_CONDITION"));
        }
        if (view_id == null || column_id == null) {
            this.addConstraint(operator, cond);
        } else {
            this.addConstraint(operator, "[" + view_id + "." + column_id + "] " + cond);
        }
    }

    @Override
    public List<WhereCondition> getConstraints() {
        return this.constraints;
    }

    @Override
    public void setConstraints(List<WhereCondition> constraints) {
        this.constraints = constraints;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public List<OrderBy> getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(List<OrderBy> order) {
        this.order = order;
    }

    @Override
    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    @Override
    public void setSchemaMeta(SchemaMeta schemaMeta) {
        this.schemaMeta = schemaMeta;
    }

    @Override
    public BusinessModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(BusinessModel model) {
        this.model = model;
    }

    @Override
    public void setSelections(List<Selection> selections) {
        this.selections = selections;
    }

    @Override
    public void setDisableDistinct(boolean value) {
        this.disableDistinct = value;
    }

    @Override
    public boolean getDisableDistinct() {
        return this.disableDistinct;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    protected String getElementText(Document doc, String name) {
        try {
            return doc.getElementsByTagName(name).item(0).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getElementText(Element ele, String name) {
        try {
            return ele.getElementsByTagName(name).item(0).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }
}

