/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.RelationshipMeta;

public class Path {
    private List<RelationshipMeta> path = new ArrayList<RelationshipMeta>();

    public void addRelationship(RelationshipMeta rel) {
        this.path.add(rel);
    }

    public void removeRelationship() {
        this.path.remove(this.size() - 1);
    }

    public RelationshipMeta removeRelationship(int i) {
        return this.path.remove(i);
    }

    public RelationshipMeta getLastRelationship() {
        return this.path.get(this.size() - 1);
    }

    public int size() {
        return this.path.size();
    }

    public int nrTables() {
        return this.getUsedTables().size();
    }

    public int score() {
        BusinessTable to;
        int size;
        int score = 0;
        for (int i = 0; i < this.size(); ++i) {
            RelationshipMeta rel = this.getRelationship(i);
            BusinessTable from = rel.getTableFrom();
            int size2 = from.getRelativeSize();
            if (size2 <= 0) continue;
            score += size2;
        }
        if (this.size() > 0 && (size = (to = this.getLastRelationship().getTableTo()).getRelativeSize()) > 0) {
            score += size;
        }
        return score;
    }

    public RelationshipMeta getRelationship(int i) {
        return this.path.get(i);
    }

    public boolean contains(Path in) {
        if (in.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            int nr;
            for (nr = 0; this.getRelationship(i + nr).equals(in.getRelationship(nr)) && nr < in.size() && i + nr < this.size(); ++nr) {
            }
            if (nr != in.size()) continue;
            return true;
        }
        return false;
    }

    public boolean contains(RelationshipMeta rel) {
        if (rel == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            RelationshipMeta check = this.getRelationship(i);
            BusinessTable from = check.getTableFrom();
            BusinessTable to = check.getTableTo();
            if ((!rel.getTableFrom().equals(from) || !rel.getTableTo().equals(to)) && (!rel.getTableFrom().equals(to) || !rel.getTableTo().equals(from))) continue;
            return true;
        }
        return false;
    }

    public boolean contains(BusinessTable tab) {
        if (tab == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            RelationshipMeta check = this.getRelationship(i);
            if (!check.isUsingTable(tab)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(BusinessTable[] tabs) {
        if (tabs == null) {
            return false;
        }
        boolean all = true;
        for (int i = 0; i < tabs.length && all; ++i) {
            if (this.contains(tabs[i])) continue;
            all = false;
        }
        return all;
    }

    public boolean contains(ArrayList tabs) {
        if (tabs == null) {
            return false;
        }
        boolean all = true;
        for (int i = 0; i < tabs.size() && all; ++i) {
            if (this.contains((BusinessTable)tabs.get(i))) continue;
            all = false;
        }
        return all;
    }

    public Object clone() {
        Path retval = new Path();
        for (int i = 0; i < this.size(); ++i) {
            RelationshipMeta rel = this.getRelationship(i);
            retval.addRelationship(rel);
        }
        return retval;
    }

    public String toString() {
        String thisPath = "";
        for (int i = 0; i < this.size(); ++i) {
            RelationshipMeta relationship = this.getRelationship(i);
            if (i > 0) {
                thisPath = thisPath + ", ";
            }
            thisPath = thisPath + "[" + relationship.getTableFrom().getId() + "-" + relationship.getTableTo().getId() + "]";
        }
        return thisPath;
    }

    public int compare(Path thisPath) {
        int diff = this.size() - thisPath.size();
        if (diff == 0 && (diff = this.nrTables() - thisPath.nrTables()) == 0) {
            diff = this.score() - thisPath.score();
        }
        if (diff < 0) {
            return -1;
        }
        if (diff > 0) {
            return 1;
        }
        return 0;
    }

    public List<BusinessTable> getUsedTables() {
        TreeSet<BusinessTable> treeSet = new TreeSet<BusinessTable>();
        for (int i = 0; i < this.size(); ++i) {
            RelationshipMeta rel = this.getRelationship(i);
            treeSet.add(rel.getTableFrom());
            treeSet.add(rel.getTableTo());
        }
        return new ArrayList<BusinessTable>(treeSet);
    }

    public RelationshipMeta[] getUsedRelationships() {
        ArrayList<RelationshipMeta> list = new ArrayList<RelationshipMeta>();
        for (int i = 0; i < this.size(); ++i) {
            RelationshipMeta rel = this.getRelationship(i);
            boolean exists = false;
            for (int j = 0; j < list.size() && !exists; ++j) {
                RelationshipMeta check = (RelationshipMeta)list.get(j);
                if (!check.isUsingTable(rel.getTableFrom()) || !check.isUsingTable(rel.getTableTo())) continue;
                exists = true;
            }
            if (exists) continue;
            list.add(rel);
        }
        RelationshipMeta[] rels = new RelationshipMeta[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            rels[i] = (RelationshipMeta)list.get(i);
        }
        return rels;
    }
}

