/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.pms.mql.dialect.BaseHiveDialect;
import org.pentaho.pms.mql.dialect.SQLJoin;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.pms.util.Const;

public class ImpalaDialect
extends BaseHiveDialect {
    protected static final String HIVE_DIALECT_TYPE = "IMPALA";
    protected static final String DRIVER_CLASS_NAME = "org.apache.hive.jdbc.HiveDriver";

    public ImpalaDialect() {
        super(HIVE_DIALECT_TYPE);
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    protected static String getHiveDialectType() {
        return HIVE_DIALECT_TYPE;
    }

    @Override
    protected List<SQLQueryModel.SQLWhereFormula> generateOuterJoin(SQLQueryModel query, StringBuilder sql) {
        throw new RuntimeException(Messages.getErrorString("ImpalaDialect.ERROR_0001_OUTER_JOIN_NOT_SUPPORTED", new Object[0]));
    }

    @Override
    protected void generateHaving(SQLQueryModel query, StringBuilder sql) {
        if (!query.getHavings().isEmpty()) {
            throw new RuntimeException(Messages.getErrorString("ImpalaDialect.ERROR_0004_HAVING_NOT_SUPPORTED", new Object[0]));
        }
    }

    @Override
    protected void generateSelect(SQLQueryModel query, StringBuilder sql) {
        sql.append("SELECT ");
        this.generateSelectPredicate(query, sql);
        sql.append(Const.CR);
        boolean first = true;
        for (SQLQueryModel.SQLSelection selection : query.getSelections()) {
            if (first) {
                first = false;
                sql.append("          ");
            } else {
                sql.append("         ,");
            }
            sql.append(selection.getFormula());
            if (selection.getAlias() != null) {
                sql.append(" AS ");
                sql.append(selection.getAlias());
            }
            sql.append(Const.CR);
        }
    }

    @Override
    protected String getFromAndWhereClauseWithInnerJoins(SQLQueryModel query) {
        StringBuilder sql = new StringBuilder();
        ArrayList<SQLJoin> joins = new ArrayList<SQLJoin>(query.getJoins());
        HashSet<String> usedTables = new HashSet<String>();
        LinkedList<SQLJoin> joinsForWhereClause = new LinkedList<SQLJoin>();
        Collections.sort(joins, BaseHiveDialect.InnerJoinComparator.getInstance());
        SQLJoin join = (SQLJoin)joins.get(0);
        String firstTable = this.getTableAndAlias(join.getLeftTablename(), join.getLeftTableAlias());
        sql.append("          ").append(firstTable);
        sql.append(Const.CR);
        usedTables.add(firstTable);
        this.connectNode(sql, usedTables, joins, joinsForWhereClause);
        if (!joins.isEmpty()) {
            throw new RuntimeException(String.format(Messages.getErrorString("ImpalaDialect.ERROR_0002_JOIN_PATH_NOT_FOUND", this.getTableAndAlias(join.getLeftTablename(), join.getLeftTableAlias()), this.getTableAndAlias(join.getRightTablename(), join.getRightTableAlias())), new Object[0]));
        }
        this.generateInnerJoinWhereConditions(query, sql, joinsForWhereClause);
        return sql.toString();
    }

    @Override
    protected void connectNode(StringBuilder sql, Set<String> usedTables, List<SQLJoin> unusedJoins, List<SQLJoin> joinsForWhereClause) {
        Iterator<SQLJoin> iter = unusedJoins.iterator();
        while (iter.hasNext()) {
            SQLJoin join = iter.next();
            String lhs = this.getTableAndAlias(join.getLeftTablename(), join.getLeftTableAlias());
            String rhs = this.getTableAndAlias(join.getRightTablename(), join.getRightTableAlias());
            boolean lhsUsed = usedTables.contains(lhs);
            boolean rhsUsed = usedTables.contains(rhs);
            if (lhsUsed && rhsUsed) {
                throw new RuntimeException(Messages.getErrorString("ImpalaDialect.ERROR_0003_ADDITIONAL_JOIN_CONDITIONS_FOUND", lhs, rhs));
            }
            if (!lhsUsed && !rhsUsed) continue;
            if (!lhsUsed && rhsUsed) {
                String t = lhs;
                lhs = rhs;
                rhs = t;
            }
            iter.remove();
            usedTables.add(rhs);
            sql.append("          JOIN ");
            sql.append(rhs);
            if (!this.isValidJoinFormula(join.getSqlWhereFormula().getFormula())) {
                joinsForWhereClause.add(join);
            } else {
                sql.append(" ON ( ").append(join.getSqlWhereFormula().getFormula()).append(" )");
            }
            sql.append(Const.CR);
            this.connectNode(sql, usedTables, unusedJoins, joinsForWhereClause);
            break;
        }
    }

    @Override
    protected void generateOrderBy(SQLQueryModel query, StringBuilder sql) {
        if (query.getOrderBys().size() > 0) {
            sql.append("ORDER BY ").append(Const.CR);
            boolean first = true;
            for (SQLQueryModel.SQLOrderBy orderby : query.getOrderBys()) {
                if (first) {
                    first = false;
                    sql.append("          ");
                } else {
                    sql.append("         ,");
                }
                if (orderby.getSelection().getAlias() != null) {
                    sql.append(orderby.getSelection().getAlias());
                } else {
                    sql.append(orderby.getSelection().getFormula());
                }
                if (orderby.getOrder() != null) {
                    sql.append(" ");
                    switch (orderby.getOrder()) {
                        case ASCENDING: {
                            sql.append("ASC");
                            break;
                        }
                        case DESCENDING: {
                            sql.append("DESC");
                            break;
                        }
                        default: {
                            throw new RuntimeException("unsupported order type: " + (Object)((Object)orderby.getOrder()));
                        }
                    }
                }
                sql.append(Const.CR);
            }
        }
    }
}

