/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.mql.dialect.DefaultSQLDialect;
import org.pentaho.pms.mql.dialect.DefaultSQLFunctionGenerator;
import org.pentaho.pms.mql.dialect.FormulaTraversalInterface;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;

public class OracleDialect
extends DefaultSQLDialect {
    public OracleDialect() {
        super("ORACLE");
        this.supportedFunctions.put("NOW", new DefaultSQLFunctionGenerator(1, "SYSDATE", 0){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append(this.sql);
            }
        });
        this.supportedFunctions.put("TRUE", new DefaultSQLFunctionGenerator(1, "TRUE()", 0){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append("1=1");
            }
        });
        this.supportedFunctions.put("FALSE", new DefaultSQLFunctionGenerator(1, "FALSE()", 0){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append("1=0");
            }
        });
    }

    @Override
    public String getDateSQL(int year, int month, int day) {
        return "TO_DATE(" + this.quoteStringLiteral(year + "-" + this.displayAsTwoOrMoreDigits(month) + "-" + this.displayAsTwoOrMoreDigits(day)) + "," + this.quoteStringLiteral("YYYY-MM-DD") + ")";
    }

    @Override
    public String getDateSQL(int year, int month, int day, int hour, int minute, int second, int milli) {
        return "TO_DATE(" + this.quoteStringLiteral(year + "-" + this.displayAsTwoOrMoreDigits(month) + "-" + this.displayAsTwoOrMoreDigits(day) + " " + this.displayAsTwoOrMoreDigits(hour) + ":" + this.displayAsTwoOrMoreDigits(minute) + ":" + this.displayAsTwoOrMoreDigits(second)) + "," + this.quoteStringLiteral("YYYY-MM-DD HH24:MI:SS") + ")";
    }

    @Override
    public int getMaxTableNameLength() {
        return 30;
    }

    @Override
    protected String getStringConcatOperator() {
        return "||";
    }

    @Override
    public boolean supportsNLSLiteral() {
        return true;
    }

    @Override
    public String generateSelectStatement(SQLQueryModel query) {
        if (query.getLimit() >= 0) {
            String origSelect = super.generateSelectStatement(query);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM (");
            sql.append(origSelect);
            sql.append(") WHERE ROWNUM <= ");
            sql.append(query.getLimit());
            return sql.toString();
        }
        return super.generateSelectStatement(query);
    }

    @Override
    protected void generateSelectPredicate(SQLQueryModel query, StringBuilder sql) {
        this.generateDistinct(query, sql);
    }
}

