/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.pms.mql.dialect.JoinType;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.pms.util.Const;

public class SQLJoin
implements Comparable<SQLJoin> {
    private String leftTablename;
    private String leftTableAlias;
    private String rightTablename;
    private String rightTableAlias;
    private SQLQueryModel.SQLWhereFormula sqlWhereFormula;
    private JoinType joinType;
    private String joinOrderKey;
    private boolean legacyJoinOrder = false;
    private static final Log logger = LogFactory.getLog(SQLJoin.class);

    public SQLJoin(String leftTablename, String leftTableAlias, String rightTablename, String rightTableAlias, SQLQueryModel.SQLWhereFormula sqlWhereFormula, JoinType joinType, String joinOrderKey) {
        this.leftTablename = leftTablename;
        this.leftTableAlias = leftTableAlias;
        this.rightTablename = rightTablename;
        this.rightTableAlias = rightTableAlias;
        this.sqlWhereFormula = sqlWhereFormula;
        this.joinType = joinType;
        this.joinOrderKey = joinOrderKey;
    }

    public SQLJoin(String leftTablename, String leftTableAlias, String rightTablename, String rightTableAlias, SQLQueryModel.SQLWhereFormula sqlWhereFormula, JoinType joinType, String joinOrderKey, boolean legacyJoinOrder) {
        this(leftTablename, leftTableAlias, rightTablename, rightTableAlias, sqlWhereFormula, joinType, joinOrderKey);
        this.legacyJoinOrder = legacyJoinOrder;
    }

    public String getLeftTablename() {
        return this.leftTablename;
    }

    public void setLeftTablename(String leftTablename) {
        this.leftTablename = leftTablename;
    }

    public String getRightTablename() {
        return this.rightTablename;
    }

    public void setRightTablename(String rightTablename) {
        this.rightTablename = rightTablename;
    }

    public SQLQueryModel.SQLWhereFormula getSqlWhereFormula() {
        return this.sqlWhereFormula;
    }

    public void setSqlWhereFormula(SQLQueryModel.SQLWhereFormula sqlWhereFormula) {
        this.sqlWhereFormula = sqlWhereFormula;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public String getJoinOrderKey() {
        return this.joinOrderKey;
    }

    public void setJoinOrderKey(String joinOrderKey) {
        this.joinOrderKey = joinOrderKey;
    }

    @Override
    public int compareTo(SQLJoin other) {
        if (Const.isEmpty(this.getJoinOrderKey()) && Const.isEmpty(other.getJoinOrderKey())) {
            if (this.legacyJoinOrder) {
                return this.legacyCompare();
            }
            if (this.getJoinType() == other.getJoinType()) {
                return 0;
            }
            if (this.getJoinType() == JoinType.INNER_JOIN) {
                return -1;
            }
            if (other.getJoinType() == JoinType.INNER_JOIN) {
                return 1;
            }
            return 0;
        }
        if (!Const.isEmpty(this.getJoinOrderKey()) && Const.isEmpty(other.getJoinOrderKey())) {
            if (this.getJoinType() != JoinType.INNER_JOIN) {
                return 1;
            }
            return 0;
        }
        if (Const.isEmpty(this.getJoinOrderKey()) && !Const.isEmpty(other.getJoinOrderKey())) {
            if (this.getJoinType() == JoinType.INNER_JOIN) {
                return -1;
            }
            return 0;
        }
        return -this.getJoinOrderKey().compareTo(other.getJoinOrderKey());
    }

    private int legacyCompare() {
        logger.debug((Object)"Using legacy SQLJoin compare.");
        if (this.getJoinType() == JoinType.INNER_JOIN) {
            return -1;
        }
        return 0;
    }

    public String getLeftTableAlias() {
        return this.leftTableAlias;
    }

    public void setLeftTableAlias(String leftTableAlias) {
        this.leftTableAlias = leftTableAlias;
    }

    public String getRightTableAlias() {
        return this.rightTableAlias;
    }

    public void setRightTableAlias(String rightTableAlias) {
        this.rightTableAlias = rightTableAlias;
    }
}

