/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.PhysicalColumn;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptUtilityBase;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.util.Const;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.Settings;
import org.pentaho.pms.util.UniqueList;

public class BusinessColumn
extends ConceptUtilityBase
implements ChangedFlagInterface,
ConceptUtilityInterface,
Cloneable {
    private static final Log logger = LogFactory.getLog(BusinessColumn.class);
    private PhysicalColumn physicalColumn;
    private boolean enabled = true;
    private BusinessTable businessTable;

    public BusinessColumn() {
    }

    public BusinessColumn(String id, PhysicalColumn physicalColumn, BusinessTable businessTable) {
        super(id);
        this.setBusinessTable(businessTable);
        this.setPhysicalColumn(physicalColumn);
    }

    public BusinessColumn(String id) {
        super(id);
    }

    @Override
    public String getModelElementDescription() {
        return Messages.getString("BusinessColumn.USER_DESCRIPTION");
    }

    public Object clone() {
        try {
            BusinessColumn businessColumn = (BusinessColumn)super.clone();
            businessColumn.setConcept((ConceptInterface)this.getConcept().clone());
            businessColumn.setPhysicalColumn(this.physicalColumn);
            return businessColumn;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public BusinessColumn cloneUnique(String locale, UniqueList columns) {
        BusinessColumn businessColumn = (BusinessColumn)this.clone();
        String newId = BusinessColumn.proposeId(locale, this.businessTable, this.physicalColumn, columns);
        try {
            businessColumn.setId(newId);
        }
        catch (ObjectAlreadyExistsException e) {
            logger.error((Object)Messages.getErrorString("BusinessColumn.ERROR_0005_UNEXPECTED_ID_EXISTS", newId), (Throwable)e);
            return null;
        }
        return businessColumn;
    }

    public static final String proposeId(String locale, BusinessTable businessTable, PhysicalColumn physicalColumn) {
        String baseID = Const.toID(businessTable.getDisplayName(locale));
        String namePart = Const.toID(Const.NVL(physicalColumn.getName(locale), physicalColumn.getFormula()));
        String id = Settings.getBusinessColumnIDPrefix() + baseID + "_" + namePart;
        if (Settings.isAnIdUppercase()) {
            id = id.toUpperCase();
        }
        return id;
    }

    public static final String proposeId(String locale, BusinessTable businessTable, PhysicalColumn physicalColumn, UniqueList columns) {
        boolean gotNew = false;
        boolean found = false;
        String id = BusinessColumn.proposeId(locale, businessTable, physicalColumn);
        int catNr = 1;
        String newId = id;
        while (!gotNew) {
            for (ConceptUtilityBase element : columns) {
                if (!element.getId().equalsIgnoreCase(newId)) continue;
                found = true;
                break;
            }
            if (found) {
                newId = id + "_" + ++catNr;
                found = false;
                continue;
            }
            gotNew = true;
        }
        if (Settings.isAnIdUppercase()) {
            newId = newId.toUpperCase();
        }
        return newId;
    }

    @Override
    public String toString() {
        return this.businessTable.getId() + "." + this.getId();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public PhysicalColumn getPhysicalColumn() {
        return this.physicalColumn;
    }

    public void setPhysicalColumn(PhysicalColumn physicalColumn) {
        this.physicalColumn = physicalColumn;
        if (physicalColumn != null) {
            this.getConcept().setInheritedInterface(physicalColumn.getConcept());
        } else {
            this.getConcept().setInheritedInterface(null);
        }
    }

    public BusinessTable getBusinessTable() {
        return this.businessTable;
    }

    public void setBusinessTable(BusinessTable businessTable) {
        this.businessTable = businessTable;
    }
}

