/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.gui.Point;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.PMSFormula;
import org.pentaho.pms.schema.BusinessCategory;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessColumnString;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.MondrianModelExporter;
import org.pentaho.pms.schema.PhysicalColumn;
import org.pentaho.pms.schema.PhysicalTable;
import org.pentaho.pms.schema.RelationshipMeta;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptUtilityBase;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.schema.olap.OlapCube;
import org.pentaho.pms.schema.olap.OlapDimension;
import org.pentaho.pms.util.Const;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.UniqueArrayList;
import org.pentaho.pms.util.UniqueList;

public class BusinessModel
extends ConceptUtilityBase
implements ChangedFlagInterface,
Cloneable,
ConceptUtilityInterface {
    private UniqueList<BusinessTable> businessTables = new UniqueArrayList<BusinessTable>();
    private List<RelationshipMeta> relationships = new ArrayList<RelationshipMeta>();
    private List<NotePadMeta> notes = new ArrayList<NotePadMeta>();
    private UniqueList<OlapDimension> olapDimensions = new UniqueArrayList<OlapDimension>();
    private UniqueList<OlapCube> olapCubes = new UniqueArrayList<OlapCube>();
    private BusinessCategory rootCategory;
    public DatabaseMeta connection = null;

    public BusinessModel() {
        BusinessCategory businessCategory = new BusinessCategory();
        businessCategory.setRootCategory(true);
        this.setRootCategory(businessCategory);
    }

    public BusinessModel(String id) {
        this();
        try {
            this.setId(id);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public String getModelElementDescription() {
        return Messages.getString("BusinessModel.USER_DESCRIPTION");
    }

    public List<RelationshipMeta> getRelationships() {
        return this.relationships;
    }

    public Object clone() {
        try {
            BusinessModel businessModel = (BusinessModel)super.clone();
            businessModel.setConcept((ConceptInterface)this.getConcept().clone());
            return businessModel;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public RelationshipMeta getRelationship(int i) {
        return this.relationships.get(i);
    }

    public void removeRelationship(RelationshipMeta relationship) {
        int i = this.relationships.indexOf(relationship);
        this.removeRelationship(i);
    }

    public void removeRelationship(int i) {
        this.relationships.remove(i);
        this.setChanged();
    }

    public void addRelationship(RelationshipMeta relationshipMeta) {
        this.relationships.add(relationshipMeta);
        this.setChanged();
    }

    public void addRelationship(int p, RelationshipMeta relationshipMeta) throws ObjectAlreadyExistsException {
        this.relationships.add(p, relationshipMeta);
        this.setChanged();
    }

    public int indexOfRelationship(RelationshipMeta relationshipMeta) {
        return this.relationships.indexOf(relationshipMeta);
    }

    public int nrRelationships() {
        return this.relationships.size();
    }

    public RelationshipMeta findRelationship(String from, String to) {
        for (int i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta relationshipMeta = this.getRelationship(i);
            if (!relationshipMeta.getTableFrom().getId().equals(from) || !relationshipMeta.getTableTo().getId().equals(to)) continue;
            return relationshipMeta;
        }
        return null;
    }

    public RelationshipMeta findRelationship(String id) {
        for (int i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta relationshipMeta = this.getRelationship(i);
            if (!relationshipMeta.toString().equals(id)) continue;
            return relationshipMeta;
        }
        return null;
    }

    public UniqueList getBusinessTables() {
        return this.businessTables;
    }

    public int nrBusinessTables() {
        return this.businessTables.size();
    }

    public BusinessTable getBusinessTable(int i) {
        return this.businessTables.get(i);
    }

    public void addBusinessTable(BusinessTable businessTable) throws ObjectAlreadyExistsException {
        this.businessTables.add(businessTable);
        this.setChanged();
    }

    public void addBusinessTable(int p, BusinessTable businessTable) throws ObjectAlreadyExistsException {
        this.businessTables.add(p, businessTable);
        this.setChanged();
    }

    public int indexOfBusinessTable(BusinessTable businessTable) {
        return this.businessTables.indexOf(businessTable);
    }

    public void removeBusinessTable(int i) {
        this.getBusinessTable(i).getConcept().setSecurityParentInterface(null);
        this.businessTables.remove(i);
        this.setChanged();
    }

    public List getNotes() {
        return this.notes;
    }

    public void setNotes(List<NotePadMeta> notes) {
        this.notes = notes;
    }

    public int nrSelected() {
        int count = 0;
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            if (!this.getBusinessTable(i).isSelected()) continue;
            ++count;
        }
        return count;
    }

    public BusinessTable[] getSelected() {
        BusinessTable[] bTables = new BusinessTable[this.nrSelected()];
        int j = 0;
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable aTable = this.getBusinessTable(i);
            if (!aTable.isSelected()) continue;
            bTables[j++] = aTable;
        }
        return bTables;
    }

    public BusinessTable getSelected(int nr) {
        int count = 0;
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            if (!this.getBusinessTable(i).isSelected()) continue;
            if (nr == count) {
                return this.getBusinessTable(i);
            }
            ++count;
        }
        return null;
    }

    public String getSelectedName(String locale, int nr) {
        BusinessTable table = this.getSelected(nr);
        if (table != null) {
            return table.getConcept().getName(locale);
        }
        return null;
    }

    public void selectInRect(Rectangle rect) {
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable ti = this.getBusinessTable(i);
            Point p = ti.getLocation();
            if (!rect.contains(p.x, p.y)) continue;
            ti.setSelected(true);
        }
    }

    public Point[] getSelectedLocations() {
        int sels = this.nrSelected();
        Point[] retval = new Point[sels];
        for (int i = 0; i < sels; ++i) {
            BusinessTable ti = this.getSelected(i);
            Point p = ti.getLocation();
            retval[i] = new Point(p.x, p.y);
        }
        return retval;
    }

    public BusinessTable[] getSelectedTables() {
        int sels = this.nrSelected();
        if (sels == 0) {
            return null;
        }
        BusinessTable[] retval = new BusinessTable[sels];
        for (int i = 0; i < sels; ++i) {
            BusinessTable table;
            retval[i] = table = this.getSelected(i);
        }
        return retval;
    }

    public void unselectAll() {
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            this.getBusinessTable(i).setSelected(false);
        }
    }

    public void selectAll() {
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            this.getBusinessTable(i).setSelected(true);
        }
    }

    public Point getMaximum() {
        Point location;
        int i;
        int maxx = 0;
        int maxy = 0;
        for (i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable businessTable = this.getBusinessTable(i);
            location = businessTable.getLocation();
            if (location.x > maxx) {
                maxx = location.x;
            }
            if (location.y <= maxy) continue;
            maxy = location.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta notePadMeta = this.getNote(i);
            location = notePadMeta.getLocation();
            if (location.x + notePadMeta.width > maxx) {
                maxx = location.x + notePadMeta.width;
            }
            if (location.y + notePadMeta.height <= maxy) continue;
            maxy = location.y + notePadMeta.height;
        }
        return new Point(maxx + 100, maxy + 100);
    }

    public void addNote(NotePadMeta ni) {
        this.notes.add(ni);
        this.setChanged();
    }

    public void addNote(int p, NotePadMeta ni) {
        this.notes.add(p, ni);
        this.setChanged();
    }

    public NotePadMeta getNote(int i) {
        return this.notes.get(i);
    }

    public void removeNote(int i) {
        if (i < 0 || i >= this.notes.size()) {
            return;
        }
        this.notes.remove(i);
        this.setChanged();
    }

    public int nrNotes() {
        return this.notes.size();
    }

    public int indexOfNote(Object ni) {
        return this.notes.indexOf(ni);
    }

    public NotePadMeta getNote(int x, int y) {
        int s = this.notes.size();
        for (int i = s - 1; i >= 0; --i) {
            NotePadMeta ni = this.notes.get(i);
            Point loc = ni.getLocation();
            Point p = new Point(loc.x, loc.y);
            if (x < p.x || x > p.x + ni.width + 10 || y < p.y || y > p.y + ni.height + 10) continue;
            return ni;
        }
        return null;
    }

    public BusinessTable getTable(int x, int y, int iconsize) {
        for (int i = this.nrBusinessTables() - 1; i >= 0; --i) {
            Point p;
            BusinessTable table = this.getBusinessTable(i);
            if (!table.isDrawn() || (p = table.getLocation()) == null || x < p.x || x > p.x + iconsize || y < p.y || y > p.y + iconsize) continue;
            return table;
        }
        return null;
    }

    public int[] getTableIndexes(BusinessTable[] tables) {
        int[] retval = new int[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            retval[i] = this.indexOfBusinessTable(tables[i]);
        }
        return retval;
    }

    public RelationshipMeta findRelationshipFrom(String id) {
        for (int i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta ri = this.getRelationship(i);
            if (!ri.getTableFrom().getId().equalsIgnoreCase(id)) continue;
            return ri;
        }
        return null;
    }

    public RelationshipMeta findRelationshipTo(String id) {
        for (int i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta ri = this.getRelationship(i);
            if (!ri.getTableTo().getId().equalsIgnoreCase(id)) continue;
            return ri;
        }
        return null;
    }

    public boolean isTableUsedInRelationships(String id) {
        RelationshipMeta fr = this.findRelationshipFrom(id);
        RelationshipMeta to = this.findRelationshipTo(id);
        return fr != null || to != null;
    }

    public ArrayList getModelTables() {
        int x;
        ArrayList<BusinessTable> modelTables = new ArrayList<BusinessTable>();
        for (x = 0; x < this.nrRelationships(); ++x) {
            RelationshipMeta hi = this.getRelationship(x);
            BusinessTable si = hi.getTableFrom();
            int idx = modelTables.indexOf(si);
            if (idx < 0) {
                modelTables.add(si);
            }
            if ((idx = modelTables.indexOf(si = hi.getTableTo())) >= 0) continue;
            modelTables.add(si);
        }
        for (x = 0; x < this.nrBusinessTables(); ++x) {
            BusinessTable table = this.getBusinessTable(x);
            if (!table.isDrawn() || this.isTableUsedInRelationships(table.getPhysicalTable().getId())) continue;
            modelTables.add(table);
        }
        return modelTables;
    }

    public int countRelationshipsUsing(BusinessTable one) {
        int nr = 0;
        for (int i = 0; i < this.nrRelationships(); ++i) {
            if (!this.getRelationship(i).isUsingTable(one)) continue;
            ++nr;
        }
        return nr;
    }

    public RelationshipMeta[] findRelationshipsUsing(BusinessTable one) {
        RelationshipMeta[] rels = new RelationshipMeta[this.countRelationshipsUsing(one)];
        int nr = 0;
        for (int i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta relationship = this.getRelationship(i);
            if (!relationship.isUsingTable(one)) continue;
            rels[nr] = relationship;
            ++nr;
        }
        return rels;
    }

    public RelationshipMeta findRelationshipUsing(BusinessTable one, BusinessTable two) {
        for (int i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta relationship = this.getRelationship(i);
            if (!relationship.isUsingTable(one) || !relationship.isUsingTable(two)) continue;
            return this.getRelationship(i);
        }
        return null;
    }

    public int nrNextRelationships(BusinessTable table) {
        int nr = 0;
        for (int i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta rel = this.getRelationship(i);
            if (!rel.isUsingTable(table)) continue;
            ++nr;
        }
        return nr;
    }

    public RelationshipMeta getNextRelationship(BusinessTable table, int getnr) {
        int nr = 0;
        for (int i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta rel = this.getRelationship(i);
            if (!rel.isUsingTable(table)) continue;
            if (getnr == nr) {
                RelationshipMeta retval = (RelationshipMeta)rel.clone();
                if (!retval.getTableFrom().getId().equalsIgnoreCase(table.getId())) {
                    retval.flip();
                }
                return retval;
            }
            ++nr;
        }
        return null;
    }

    public BusinessTable findBusinessTable(String locale, String tablename) {
        BusinessTable businessTable;
        int i;
        for (i = 0; i < this.nrBusinessTables(); ++i) {
            businessTable = this.getBusinessTable(i);
            String displayName = businessTable.getDisplayName(locale);
            if (displayName == null || !displayName.equals(tablename)) continue;
            return businessTable;
        }
        for (i = 0; i < this.nrBusinessTables(); ++i) {
            businessTable = this.getBusinessTable(i);
            String id = businessTable.getId();
            if (id == null || !id.equals(tablename)) continue;
            return businessTable;
        }
        return null;
    }

    public BusinessTable findBusinessTable(String tableID) {
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable businessTable = this.getBusinessTable(i);
            String id = businessTable.getId();
            if (id == null || !id.equalsIgnoreCase(tableID)) continue;
            return businessTable;
        }
        return null;
    }

    public List<BusinessTable> getSelectedDrawnBusinessTableList() {
        ArrayList<BusinessTable> list = new ArrayList<BusinessTable>();
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable businessTable = this.getBusinessTable(i);
            if (!businessTable.isDrawn() || !businessTable.isSelected()) continue;
            list.add(businessTable);
        }
        return list;
    }

    public int[] getBusinessTableIndexes(BusinessTable[] tables) {
        int[] retval = new int[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            retval[i] = this.indexOfBusinessTable(tables[i]);
        }
        return retval;
    }

    public void deletePhysicalTableReferences(PhysicalTable physicalTable) {
        for (int t = this.nrBusinessTables() - 1; t >= 0; --t) {
            BusinessTable businessTable = this.getBusinessTable(t);
            if (!businessTable.getPhysicalTable().equals(physicalTable)) continue;
            RelationshipMeta[] tableRelationships = this.findRelationshipsUsing(businessTable);
            for (int r = 0; r < tableRelationships.length; ++r) {
                int idx = this.indexOfRelationship(tableRelationships[r]);
                this.removeRelationship(idx);
            }
            this.removeBusinessTable(t);
        }
    }

    public BusinessCategory findBusinessCategory(String[] path, String locale) {
        return this.findBusinessCategory(path, locale, false);
    }

    public BusinessCategory findBusinessCategory(String[] path, String locale, boolean exact) {
        if (path.length == 0) {
            if (exact) {
                return null;
            }
            return this.rootCategory;
        }
        for (int i = 0; i < this.rootCategory.nrBusinessCategories(); ++i) {
            BusinessCategory businessCategory = this.rootCategory.getBusinessCategory(i);
            BusinessCategory found = this.findBusinessCategory(path, 0, businessCategory, locale, exact);
            if (found == null) continue;
            return found;
        }
        if (exact) {
            return null;
        }
        return this.rootCategory;
    }

    private BusinessCategory findBusinessCategory(String[] path, int level, BusinessCategory businessCategory, String locale, boolean exact) {
        if (path[level].equals(businessCategory.getDisplayName(locale)) || path[level].equals(businessCategory.getId())) {
            if (level >= path.length - 1) {
                return businessCategory;
            }
            for (int i = 0; i < businessCategory.nrBusinessCategories(); ++i) {
                BusinessCategory category = businessCategory.getBusinessCategory(i);
                BusinessCategory found = this.findBusinessCategory(path, level + 1, category, locale, exact);
                if (found == null) continue;
                return found;
            }
            if (exact) {
                return null;
            }
            return businessCategory;
        }
        return null;
    }

    public UniqueList<BusinessColumn> getAllBusinessColumns() {
        UniqueArrayList<BusinessColumn> columns = new UniqueArrayList<BusinessColumn>();
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable businessTable = this.getBusinessTable(i);
            for (int j = 0; j < businessTable.nrBusinessColumns(); ++j) {
                try {
                    columns.add(businessTable.getBusinessColumn(j));
                    continue;
                }
                catch (ObjectAlreadyExistsException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return columns;
    }

    public BusinessColumn findBusinessColumn(String columnId) {
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable businessTable = this.getBusinessTable(i);
            BusinessColumn businessColumn = businessTable.findBusinessColumn(columnId);
            if (businessColumn == null) continue;
            return businessColumn;
        }
        return null;
    }

    public BusinessColumn findBusinessColumn(String locale, String name) {
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable businessTable = this.getBusinessTable(i);
            BusinessColumn businessColumn = businessTable.findBusinessColumn(locale, name);
            if (businessColumn == null) continue;
            return businessColumn;
        }
        return null;
    }

    public List getFlatCategoriesView(String locale) {
        ArrayList<BusinessColumnString> strings = new ArrayList<BusinessColumnString>();
        Stack<BusinessCategory> categoriesPath = new Stack<BusinessCategory>();
        this.getFlatCategoriesView(strings, categoriesPath, this.rootCategory, locale);
        return strings;
    }

    private void getFlatCategoriesView(List<BusinessColumnString> strings, Stack<BusinessCategory> categoriesPath, BusinessCategory parentCategory, String locale) {
        int i;
        StringBuffer pathString = new StringBuffer();
        for (int i2 = 0; i2 < categoriesPath.size(); ++i2) {
            BusinessCategory businessCategory = (BusinessCategory)categoriesPath.get(i2);
            if (i2 > 0) {
                pathString.append(" - ");
            }
            String categoryName = businessCategory.getDisplayName(locale);
            if (i2 + 1 == categoriesPath.size()) {
                pathString.append(categoryName);
                continue;
            }
            pathString.append(Const.rightPad(" ", categoryName.length()));
        }
        BusinessColumnString categoryString = new BusinessColumnString(pathString.toString(), strings.size(), null);
        strings.add(categoryString);
        for (i = 0; i < parentCategory.nrBusinessCategories(); ++i) {
            BusinessCategory businessCategory = parentCategory.getBusinessCategory(i);
            categoriesPath.push(businessCategory);
            this.getFlatCategoriesView(strings, categoriesPath, businessCategory, locale);
            categoriesPath.pop();
        }
        for (i = 0; i < parentCategory.nrBusinessColumns(); ++i) {
            BusinessColumn businessColumn = parentCategory.getBusinessColumn(i);
            if (businessColumn.getPhysicalColumn().isHidden()) continue;
            String desc = Const.rightPad(" ", pathString.length()) + "  " + businessColumn.getDisplayName(locale);
            BusinessColumnString columnString = new BusinessColumnString(desc, strings.size(), businessColumn);
            strings.add(columnString);
        }
    }

    public BusinessCategory getRootCategory() {
        return this.rootCategory;
    }

    public void setRootCategory(BusinessCategory rootCategory) {
        this.rootCategory = rootCategory;
        rootCategory.getConcept().setSecurityParentInterface(this.getConcept());
    }

    public BusinessTable findBusinessTable(BusinessColumn businessColumn) {
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable businessTable = this.getBusinessTable(i);
            if (businessTable.findBusinessColumn(businessColumn.getId()) == null) continue;
            return businessTable;
        }
        return null;
    }

    @Override
    public boolean hasChanged() {
        if (this.haveTablesChanged()) {
            return true;
        }
        if (this.haveRelationshipsChanged()) {
            return true;
        }
        if (this.rootCategory.hasChanged()) {
            return true;
        }
        if (this.haveOlapDimensionsChanged()) {
            return true;
        }
        if (this.haveOlapCubesChanged()) {
            return true;
        }
        return super.hasChanged();
    }

    private boolean haveRelationshipsChanged() {
        for (int i = 0; i < this.nrRelationships(); ++i) {
            if (!this.getRelationship(i).hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveTablesChanged() {
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable bt = this.getBusinessTable(i);
            if (!bt.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveOlapDimensionsChanged() {
        for (int i = 0; i < this.olapDimensions.size(); ++i) {
            OlapDimension olapDimension = this.olapDimensions.get(i);
            if (!olapDimension.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveOlapCubesChanged() {
        for (int i = 0; i < this.olapCubes.size(); ++i) {
            OlapCube olapCube = this.olapCubes.get(i);
            if (!olapCube.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearChanged() {
        int i;
        super.clearChanged();
        for (i = 0; i < this.nrBusinessTables(); ++i) {
            BusinessTable businessTable = this.getBusinessTable(i);
            businessTable.clearChanged();
        }
        for (i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta relationshipMeta = this.getRelationship(i);
            relationshipMeta.clearChanged();
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta notePadMeta = this.getNote(i);
            notePadMeta.setChanged(false);
        }
        for (i = 0; i < this.olapDimensions.size(); ++i) {
            OlapDimension olapDimension = this.olapDimensions.get(i);
            olapDimension.clearChanged();
        }
        for (i = 0; i < this.olapCubes.size(); ++i) {
            OlapCube olapCube = this.olapCubes.get(i);
            olapCube.setChanged(false);
        }
        this.rootCategory.clearChanged();
    }

    public int getNrNeighbours(BusinessTable businessTable, List selectedTables) {
        int nr = 0;
        for (int i = 0; i < this.nrRelationships(); ++i) {
            RelationshipMeta relationship = this.getRelationship(i);
            if (!relationship.isUsingTable(businessTable)) continue;
            boolean found = false;
            for (int s = 0; s < selectedTables.size() && !found; ++s) {
                BusinessTable selectedTable = (BusinessTable)selectedTables.get(s);
                if (!relationship.isUsingTable(selectedTable) || businessTable.equals(selectedTable)) continue;
                ++nr;
            }
        }
        return nr;
    }

    public List<OlapDimension> getOlapDimensions() {
        return this.olapDimensions.getList();
    }

    public OlapDimension findOlapDimension(String name) {
        for (int i = 0; i < this.olapDimensions.size(); ++i) {
            OlapDimension dimension = this.olapDimensions.get(i);
            if (!dimension.getName().equalsIgnoreCase(name)) continue;
            return dimension;
        }
        return null;
    }

    public String[] getBusinessTableNames(String locale) {
        String[] names = new String[this.nrBusinessTables()];
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            names[i] = this.getBusinessTable(i).getDisplayName(locale);
        }
        return names;
    }

    public String getMondrianModel(String locale) throws Exception {
        MondrianModelExporter exporter = new MondrianModelExporter(this, locale);
        String xml = exporter.createMondrianModelXML();
        return xml;
    }

    public List<OlapCube> getOlapCubes() {
        return this.olapCubes.getList();
    }

    public OlapCube findOlapCube(String name) {
        for (int i = 0; i < this.olapCubes.size(); ++i) {
            OlapCube cube = this.olapCubes.get(i);
            if (!cube.getName().equalsIgnoreCase(name)) continue;
            return cube;
        }
        return null;
    }

    public boolean hasConnection() {
        return this.getConnection() != null;
    }

    public void setConnection(DatabaseMeta connection) {
        this.connection = connection;
        for (int i = 0; i < this.nrBusinessTables(); ++i) {
            PhysicalTable pt;
            BusinessTable bt = this.getBusinessTable(i);
            if (null == bt || null == (pt = bt.getPhysicalTable())) continue;
            pt.setDatabaseMeta(connection);
        }
    }

    public DatabaseMeta getConnection() {
        if (this.connection == null && this.nrBusinessTables() > 0) {
            this.connection = this.getBusinessTable(0).getPhysicalTable().getDatabaseMeta();
        }
        return this.connection;
    }

    public void clearConnection() {
        this.connection = null;
    }

    public boolean verify(ConceptUtilityBase base) {
        boolean verify = false;
        if (this.getConnection() == null && base != null) {
            return true;
        }
        if (base == null) {
            return false;
        }
        if (base instanceof PhysicalTable) {
            PhysicalTable physicalTable = (PhysicalTable)base;
            verify = physicalTable.getDatabaseMeta().equals((Object)this.getConnection());
        } else if (base instanceof PhysicalColumn) {
            PhysicalColumn physicalColumn = (PhysicalColumn)base;
            verify = physicalColumn.getTable().getDatabaseMeta().equals((Object)this.getConnection());
        }
        return verify;
    }

    public Collection<RelationshipMeta> getAffectedComplexRelationships(BusinessColumn column) {
        ArrayList<RelationshipMeta> relations = new ArrayList<RelationshipMeta>();
        for (RelationshipMeta relation : this.relationships) {
            if (!relation.isComplex() || relation.getCJReferencedColumns() == null || !relation.getCJReferencedColumns().contains(column)) continue;
            relations.add(relation);
        }
        return relations;
    }

    public List<RelationFormulaUpdate> updateComplexRelationships(BusinessTable oldTable, BusinessTable newTable) {
        HashMap<String, String> changes = new HashMap<String, String>();
        HashSet<RelationshipMeta> relations = new HashSet<RelationshipMeta>();
        for (BusinessColumn column : oldTable.getBusinessColumns()) {
            BusinessColumn newColumn = new BusinessColumn(column.getId(), column.getPhysicalColumn(), newTable);
            changes.put(column.toString(), newColumn.toString());
            relations.addAll(this.getAffectedComplexRelationships(column));
        }
        return this.updateComplexRelationships(changes, relations);
    }

    public List<RelationFormulaUpdate> updateComplexRelationships(BusinessColumn oldColumn, BusinessColumn newColumn) {
        ArrayList updates = new ArrayList();
        HashMap<String, String> changes = new HashMap<String, String>();
        changes.put(oldColumn.toString(), newColumn.toString());
        Collection<RelationshipMeta> relations = this.getAffectedComplexRelationships(oldColumn);
        return this.updateComplexRelationships(changes, relations);
    }

    private List<RelationFormulaUpdate> updateComplexRelationships(Map<String, String> changes, Collection<RelationshipMeta> relations) {
        ArrayList<RelationFormulaUpdate> updates = new ArrayList<RelationFormulaUpdate>();
        for (RelationshipMeta relation : relations) {
            String formulaBefore = relation.getComplexJoin();
            try {
                PMSFormula formula = relation.getComplexJoinFormula(this);
                formula.parseAndValidate();
                relation.setComplexJoin(formula.updateFields(changes));
                updates.add(new RelationFormulaUpdate(relation, formulaBefore, null));
            }
            catch (PentahoMetadataException e) {
                updates.add(new RelationFormulaUpdate(relation, formulaBefore, e));
            }
        }
        return updates;
    }

    public static class RelationFormulaUpdate {
        RelationshipMeta relationship;
        String formulaBefore;
        List<Exception> errors;

        public RelationshipMeta getRelationship() {
            return this.relationship;
        }

        public String getFormulaBefore() {
            return this.formulaBefore;
        }

        public List<Exception> getErrors() {
            return this.errors;
        }

        public RelationFormulaUpdate(RelationshipMeta rel, String before, PentahoMetadataException error) {
            this.relationship = rel;
            this.formulaBefore = before;
            this.errors = new ArrayList<Exception>();
            if (error != null) {
                this.errors.add(error);
            }
        }
    }
}

