/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.alignment;

import java.util.HashMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.pms.messages.Messages;

public class AlignmentSettings {
    public static final int TYPE_ALIGNMENT_LEFT = 0;
    public static final int TYPE_ALIGNMENT_RIGHT = 1;
    public static final int TYPE_ALIGNMENT_CENTERED = 2;
    public static final int TYPE_ALIGNMENT_JUSTIFIED = 3;
    public static final AlignmentSettings LEFT = new AlignmentSettings(0);
    public static final AlignmentSettings RIGHT = new AlignmentSettings(1);
    public static final AlignmentSettings CENTERED = new AlignmentSettings(2);
    public static final AlignmentSettings JUSTIFIED = new AlignmentSettings(3);
    private static final String[] typeCodes = new String[]{"left", "right", "centered", "justified"};
    private static final HashMap<String, AlignmentSettings> typeCodeToAlignmentSettings = new HashMap(4);
    public static final String[] typeDescriptions;
    public static final AlignmentSettings[] types;
    private int type;

    public AlignmentSettings(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlignmentSettings)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AlignmentSettings rhs = (AlignmentSettings)obj;
        return new EqualsBuilder().append(this.type, rhs.type).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(61, 223).append(this.type).toHashCode();
    }

    public String toString() {
        return this.getCode();
    }

    public static AlignmentSettings fromString(String value) {
        return typeCodeToAlignmentSettings.get(value);
    }

    public static AlignmentSettings getType(String description) {
        int i;
        for (i = 0; i < typeDescriptions.length; ++i) {
            if (!typeDescriptions[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        for (i = 0; i < typeCodes.length; ++i) {
            if (!typeCodes[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        return LEFT;
    }

    public String getCode() {
        return typeCodes[this.type];
    }

    public String getDescription() {
        return typeDescriptions[this.type];
    }

    static {
        typeCodeToAlignmentSettings.put(typeCodes[0], LEFT);
        typeCodeToAlignmentSettings.put(typeCodes[1], RIGHT);
        typeCodeToAlignmentSettings.put(typeCodes[2], CENTERED);
        typeCodeToAlignmentSettings.put(typeCodes[3], JUSTIFIED);
        typeDescriptions = new String[]{Messages.getString("AlignmentSettings.USER_LEFT_DESC"), Messages.getString("AlignmentSettings.USER_RIGHT_DESC"), Messages.getString("AlignmentSettings.USER_CENTERED_DESC"), Messages.getString("AlignmentSettings.USER_JUSTIFIED_DESC")};
        types = new AlignmentSettings[]{LEFT, RIGHT, CENTERED, JUSTIFIED};
    }
}

