/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.font;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.pms.schema.concept.types.ConceptPropertyBase;
import org.pentaho.pms.schema.concept.types.ConceptPropertyType;
import org.pentaho.pms.schema.concept.types.font.FontSettings;

public class ConceptPropertyFont
extends ConceptPropertyBase
implements Cloneable {
    private FontSettings value;

    public ConceptPropertyFont(String name, FontSettings value) {
        this(name, value, false);
    }

    public ConceptPropertyFont(String name, FontSettings value, boolean required) {
        super(name, required);
        this.value = value;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ConceptPropertyFont rtn = (ConceptPropertyFont)super.clone();
        if (this.value != null) {
            rtn.value = new FontSettings(this.value.getName(), this.value.getHeight(), this.value.isBold(), this.value.isItalic());
        }
        return rtn;
    }

    @Override
    public ConceptPropertyType getType() {
        return ConceptPropertyType.FONT;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = (FontSettings)value;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ConceptPropertyFont)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConceptPropertyFont rhs = (ConceptPropertyFont)obj;
        return new EqualsBuilder().append((Object)this.value, (Object)rhs.value).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(47, 71).append((Object)this.value).toHashCode();
    }
}

