/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.olap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.olap.OlapDimension;
import org.pentaho.pms.schema.olap.OlapHierarchyLevel;

public class OlapHierarchy
extends ChangedFlag
implements Cloneable {
    private String name;
    private BusinessTable businessTable;
    private BusinessColumn primaryKey;
    private List<OlapHierarchyLevel> hierarchyLevels;
    private boolean havingAll;
    private OlapDimension olapDimension;

    public OlapHierarchy(OlapDimension olapDimension) {
        this.olapDimension = olapDimension;
        this.hierarchyLevels = new ArrayList<OlapHierarchyLevel>();
        this.havingAll = true;
    }

    public OlapHierarchy(OlapDimension olapDimension, String name, List<OlapHierarchyLevel> hierarchyLevels) {
        this(olapDimension);
        this.name = name;
        this.hierarchyLevels = hierarchyLevels;
    }

    public Object clone() {
        OlapHierarchy hierarchy = new OlapHierarchy(this.olapDimension);
        hierarchy.name = this.name;
        if (this.businessTable != null) {
            hierarchy.businessTable = (BusinessTable)this.businessTable.clone();
        }
        if (this.primaryKey != null) {
            hierarchy.primaryKey = (BusinessColumn)this.primaryKey.clone();
        }
        for (int i = 0; i < this.hierarchyLevels.size(); ++i) {
            OlapHierarchyLevel hierarchyLevel = this.hierarchyLevels.get(i);
            hierarchy.hierarchyLevels.add((OlapHierarchyLevel)hierarchyLevel.clone());
        }
        hierarchy.havingAll = this.havingAll;
        return hierarchy;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((OlapHierarchy)obj).getName());
    }

    public List<OlapHierarchyLevel> getHierarchyLevels() {
        return this.hierarchyLevels;
    }

    public void setHierarchyLevels(List<OlapHierarchyLevel> hierarchyLevels) {
        this.hierarchyLevels = hierarchyLevels;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isHavingAll() {
        return this.havingAll;
    }

    public void setHavingAll(boolean havingAll) {
        this.havingAll = havingAll;
    }

    public BusinessColumn getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(BusinessColumn primaryKey) {
        this.primaryKey = primaryKey;
    }

    public OlapHierarchyLevel findOlapHierarchyLevel(String thisName) {
        for (int i = 0; i < this.hierarchyLevels.size(); ++i) {
            OlapHierarchyLevel level = this.hierarchyLevels.get(i);
            if (!level.getName().equalsIgnoreCase(thisName)) continue;
            return level;
        }
        return null;
    }

    public OlapDimension getOlapDimension() {
        return this.olapDimension;
    }

    public void setOlapDimension(OlapDimension olapDimension) {
        this.olapDimension = olapDimension;
    }

    public BusinessTable getBusinessTable() {
        return this.businessTable;
    }

    public void setBusinessTable(BusinessTable businessTable) {
        this.businessTable = businessTable;
    }

    public String[] getUnusedColumnNames(String locale) {
        String[] allColumnNames = this.businessTable.getColumnNames(locale);
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(Arrays.asList(allColumnNames));
        for (int i = names.size() - 1; i >= 0; --i) {
            String columnName = (String)names.get(i);
            if (this.findBusinessColumn(locale, columnName) == null) continue;
            names.remove(i);
        }
        return names.toArray(new String[names.size()]);
    }

    public BusinessColumn findBusinessColumn(String locale, String columnName) {
        for (int i = 0; i < this.hierarchyLevels.size(); ++i) {
            OlapHierarchyLevel level = this.hierarchyLevels.get(i);
            BusinessColumn businessColumn = level.findBusinessColumn(locale, columnName);
            if (businessColumn == null) continue;
            return businessColumn;
        }
        return null;
    }

    public boolean hasChanged() {
        for (int i = 0; i < this.hierarchyLevels.size(); ++i) {
            if (!this.hierarchyLevels.get(i).hasChanged()) continue;
            return true;
        }
        return super.hasChanged();
    }

    public void clearChanged() {
        for (int i = 0; i < this.hierarchyLevels.size(); ++i) {
            this.hierarchyLevels.get(i).setChanged(false);
        }
        this.setChanged(false);
    }
}

