/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.security;

import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.pms.messages.Messages;
import org.w3c.dom.Node;

public class SecurityOwner
implements Cloneable {
    public static final String STRING_USER_DESC = Messages.getString("SecurityOwner.USER_USER");
    public static final String STRING_ROLE_DESC = Messages.getString("SecurityOwner.USER_ROLE");
    public static final int OWNER_TYPE_USER = 0;
    public static final int OWNER_TYPE_ROLE = 1;
    public static final String[] ownerTypeCodes = new String[]{"user", "role"};
    public static final String[] ownerTypeDescriptions = new String[]{STRING_USER_DESC, STRING_ROLE_DESC};
    private int ownerType;
    private String ownerName;

    public SecurityOwner(int ownerType, String ownerName, int rights) {
        this.ownerType = ownerType;
        this.ownerName = ownerName;
    }

    public SecurityOwner(int ownerType, String ownerName) {
        this(ownerType, ownerName, 0);
    }

    public String toString() {
        return this.ownerName + ":" + this.getOwnerTypeDescription();
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<owner>");
        xml.append(XMLHandler.addTagValue((String)"type", (String)this.getOwnerTypeCode(), (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"name", (String)this.ownerName, (boolean)false, (String[])new String[0]));
        xml.append("</owner>");
        return xml.toString();
    }

    public SecurityOwner(Node ownerNode) {
        this.ownerType = SecurityOwner.getOwnerType(XMLHandler.getTagValue((Node)ownerNode, (String)"type"));
        this.ownerName = XMLHandler.getTagValue((Node)ownerNode, (String)"name");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof SecurityOwner) {
            SecurityOwner set = (SecurityOwner)obj;
            result = this.ownerType == set.ownerType && this.ownerName.equals(set.ownerName);
        }
        return result;
    }

    public int hashCode() {
        return new Integer(this.ownerType).hashCode() ^ this.ownerName.hashCode();
    }

    public int getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(int aclType) {
        this.ownerType = aclType;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerTypeCode() {
        return ownerTypeCodes[this.ownerType];
    }

    public String getOwnerTypeDescription() {
        return ownerTypeDescriptions[this.ownerType];
    }

    public static final int getOwnerType(String description) {
        int i;
        for (i = 0; i < ownerTypeDescriptions.length; ++i) {
            if (!ownerTypeDescriptions[i].equalsIgnoreCase(description)) continue;
            return i;
        }
        for (i = 0; i < ownerTypeCodes.length; ++i) {
            if (!ownerTypeCodes[i].equalsIgnoreCase(description)) continue;
            return i;
        }
        return 0;
    }
}

