/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.util;

import java.util.ResourceBundle;
import org.pentaho.pms.util.IVersionHelper;

public class VersionHelper
implements IVersionHelper {
    @Override
    public String getVersionInformation() {
        return this.getVersionInformation(VersionHelper.class);
    }

    @Override
    public String getVersionInformation(Class clazz) {
        return this.getVersionInformation(clazz, true);
    }

    public String getVersionInformation(Class clazz, boolean includeTitle) {
        String implTitle = clazz.getPackage().getImplementationTitle();
        String implVersion = clazz.getPackage().getImplementationVersion();
        if (implVersion != null) {
            if (includeTitle) {
                return implTitle + " " + implVersion;
            }
            return implVersion;
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("build-res.version");
            StringBuffer buff = new StringBuffer();
            if (includeTitle) {
                buff.append(bundle.getString("impl.title")).append(' ');
            }
            buff.append(bundle.getString("release.major.number")).append('.').append(bundle.getString("release.minor.number"));
            buff.append('.').append(bundle.getString("release.milestone.number")).append('.').append(bundle.getString("release.build.number")).append(" (class)");
            return buff.toString();
        }
        catch (Exception ex) {
            if (includeTitle) {
                return "Pentaho Metadata Editor - No Version Information Available";
            }
            return "No Version Information Available";
        }
    }
}

