/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs;

import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.kettle.plugins.hdfs.vfs.HadoopVfsFileChooserDialog;
import org.pentaho.big.data.kettle.plugins.hdfs.vfs.MapRFSFileChooserDialog;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

@LifecyclePlugin(id="HdfsLifecycleListener", name="HdfsLifecycleListener")
public class HdfsLifecycleListener
implements LifecycleListener {
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private HadoopVfsFileChooserDialog hadoopVfsFileChooserDialog;
    private MapRFSFileChooserDialog mapRFSFileChooserDialog;

    public HdfsLifecycleListener(NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
    }

    public void onStart(LifeEventHandler lifeEventHandler) throws LifecycleException {
        final Spoon spoon = Spoon.getInstance();
        spoon.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                VfsFileChooserDialog dialog = spoon.getVfsFileChooserDialog(null, null);
                HdfsLifecycleListener.this.hadoopVfsFileChooserDialog = new HadoopVfsFileChooserDialog("hdfs", "HDFS", dialog, null, null, HdfsLifecycleListener.this.namedClusterService, HdfsLifecycleListener.this.runtimeTestActionService, HdfsLifecycleListener.this.runtimeTester);
                dialog.addVFSUIPanel((CustomVfsUiPanel)HdfsLifecycleListener.this.hadoopVfsFileChooserDialog);
                HdfsLifecycleListener.this.mapRFSFileChooserDialog = new MapRFSFileChooserDialog("maprfs", "MapRFS", dialog);
                dialog.addVFSUIPanel((CustomVfsUiPanel)HdfsLifecycleListener.this.mapRFSFileChooserDialog);
            }
        });
    }

    public void onExit(LifeEventHandler lifeEventHandler) throws LifecycleException {
    }
}

