/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.vfs.hdfs;

import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.big.data.impl.vfs.hdfs.HDFSFileObject;
import org.pentaho.big.data.impl.vfs.hdfs.HDFSFileProvider;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystem;

public class HDFSFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final HadoopFileSystem hdfs;

    protected HDFSFileSystem(FileName rootName, FileSystemOptions fileSystemOptions, HadoopFileSystem hdfs) {
        super(rootName, null, fileSystemOptions);
        this.hdfs = hdfs;
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(HDFSFileProvider.capabilities);
        if (Boolean.parseBoolean(this.hdfs.getProperty("dfs.support.append", "true"))) {
            caps.add(Capability.APPEND_CONTENT);
        }
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new HDFSFileObject(name, this);
    }

    public HadoopFileSystem getHDFSFileSystem() throws FileSystemException {
        return this.hdfs;
    }
}

