/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.pig;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.vfs2.FileObject;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.pentaho.big.data.impl.shim.pig.KettleLoggingPrintWriter;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLogChannelAppender;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.Log4jKettleLayout;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.i18n.BaseMessages;

public class WriterAppenderManager
implements Closeable {
    private static final Class<?> PKG = WriterAppenderManager.class;
    private final Log4jFileAppender appender;
    private final WriterAppender pigToKettleAppender;
    private final LogWriter logWriter;

    public WriterAppenderManager(LogChannelInterface logChannelInterface, LogLevel logLevel, String name) {
        this(logChannelInterface, logLevel, name, LogWriter.getInstance());
    }

    public WriterAppenderManager(LogChannelInterface logChannelInterface, LogLevel logLevel, String name, LogWriter logWriter) {
        KettleLoggingPrintWriter klps = new KettleLoggingPrintWriter(logChannelInterface);
        this.pigToKettleAppender = new WriterAppender((Layout)new Log4jKettleLayout(true), (Writer)klps);
        Logger pigLogger = Logger.getLogger((String)"org.apache.pig");
        Level log4jLevel = this.getLog4jLevel(logLevel);
        pigLogger.setLevel(log4jLevel);
        String logFileName = "pdi-" + name;
        Log4jFileAppender appender = null;
        this.logWriter = logWriter;
        try {
            appender = LogWriter.createFileAppender((String)logFileName, (boolean)true, (boolean)false);
            logWriter.addAppender((Appender)appender);
            logChannelInterface.setLogLevel(logLevel);
            if (pigLogger != null) {
                pigLogger.addAppender((Appender)this.pigToKettleAppender);
            }
        }
        catch (Exception e) {
            logChannelInterface.logError(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.FailedToOpenLogFile", (String[])new String[]{logFileName, e.toString()}));
            logChannelInterface.logError(Const.getStackTracker((Throwable)e));
        }
        this.appender = appender;
    }

    private Level getLog4jLevel(LogLevel level) {
        Level log4jLevel = (Level)KettleLogChannelAppender.LOG_LEVEL_MAP.get(level);
        return log4jLevel != null ? log4jLevel : Level.INFO;
    }

    @Override
    public void close() throws IOException {
        Logger pigLogger;
        if (this.appender != null) {
            this.logWriter.removeAppender((Appender)this.appender);
            this.appender.close();
        }
        if ((pigLogger = Logger.getLogger((String)"org.apache.pig")) != null && this.pigToKettleAppender != null) {
            pigLogger.removeAppender((Appender)this.pigToKettleAppender);
            this.pigToKettleAppender.close();
        }
    }

    public FileObject getFile() {
        return this.appender == null ? null : this.appender.getFile();
    }

    public static class Factory {
        public WriterAppenderManager create(LogChannelInterface logChannelInterface, LogLevel logLevel, String name) {
            return new WriterAppenderManager(logChannelInterface, logLevel, name);
        }
    }
}

