/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.mdr.MDRObject;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.handlers.ClassLoaderProvider;
import org.netbeans.mdr.handlers.MDRClassLoader;
import org.netbeans.mdr.handlers.gen.HandlerGenerator;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.storagemodel.Transient;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.ImplClass;
import org.netbeans.mdr.util.Logger;

public abstract class BaseObjectHandler
extends ImplClass
implements MDRObject {
    private static MDRClassLoader defaultLoader = null;
    private static ClassLoaderProvider provider = null;
    static Map deletedInstances = new WeakHashMap();
    private MOFID mofId;
    private final MdrStorage mdrStorage;
    private StorableBaseObject storable;

    public static synchronized void setClassLoaderProvider(ClassLoaderProvider provider) {
        BaseObjectHandler.provider = provider;
    }

    public static synchronized MDRClassLoader getDefaultClassLoader() {
        if (defaultLoader == null) {
            defaultLoader = new MDRClassLoader(provider);
        }
        return defaultLoader;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class getHandlerClass(Class ifc, StorableBaseObject s) throws IllegalArgumentException {
        MDRClassLoader loader = BaseObjectHandler.getDefaultClassLoader();
        BaseObjectHandler.check(loader, ifc);
        Map cache = BaseObjectHandler.getLoaderCache(loader);
        String className = BaseObjectHandler.getName(ifc);
        Class result = BaseObjectHandler.getFromCache(cache, ifc, className);
        if (result != null) return result;
        try {
            try {
                StorableObject metaObject = s.getMetaObject();
                byte[] handlerClassFile = s instanceof StorableObject ? metaObject.getInstanceClassFile() : metaObject.getClassFile();
                if (handlerClassFile == null) {
                    handlerClassFile = HandlerGenerator.generateHandler(className, ifc, s);
                    if (s instanceof StorableObject) {
                        metaObject.setInstanceClassFile(handlerClassFile);
                    } else {
                        metaObject.setClassFile(handlerClassFile);
                    }
                }
                result = loader.defineClass(className, handlerClassFile);
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            BaseObjectHandler.releaseCache(cache, result, className);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        BaseObjectHandler.releaseCache(cache, result, className);
        return result;
    }

    public static Class resolveClass(StorableBaseObject s) {
        try {
            StorableObject metaObject = s.getMetaObject();
            return BaseObjectHandler.getDefaultClassLoader().resolveInterface(metaObject, !(s instanceof StorableObject));
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public static Class resolveInterface(String ifcName) throws ClassNotFoundException {
        try {
            return Class.forName(ifcName, true, BaseObjectHandler.getDefaultClassLoader());
        }
        catch (RuntimeException e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + ifcName);
            throw e;
        }
        catch (Error e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + ifcName);
            throw e;
        }
    }

    public static Class resolveImplementation(String implName) throws ClassNotFoundException {
        try {
            return Class.forName(implName, true, BaseObjectHandler.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Error e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + implName);
            throw e;
        }
        catch (RuntimeException e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + implName);
            throw e;
        }
    }

    protected BaseObjectHandler(StorableBaseObject storable) {
        this._setDelegate(storable);
        this.mdrStorage = storable.getMdrStorage();
    }

    protected final void _lock() {
        this._lock(false);
    }

    protected final void _lock(boolean write) {
        this._getRepository().beginTrans(write);
    }

    protected final void _unlock() {
        this._getRepository().endTrans();
    }

    protected final void _unlock(boolean fail) {
        this._getRepository().endTrans(fail);
    }

    public final MDRepository repository() {
        return this._getRepository();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BaseObjectHandler) {
            return this == obj;
        }
        return obj instanceof RefBaseObject && ((RefBaseObject)obj).refMofId().equals(this.refMofId());
    }

    public String toString() {
        String outP;
        String metaId;
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        try {
            metaId = this._getDelegate().getMetaObject().getMofId().toString();
        }
        catch (Exception e) {
            metaId = "(not available)";
        }
        try {
            outP = this._getDelegate().getOutermostPackage().getMofId().toString();
        }
        catch (Exception e) {
            outP = "(not available)";
        }
        return String.valueOf(className) + "  ID: " + this.refMofId() + "  MID: " + metaId + "  OPCKG: " + outP;
    }

    public final int hashCode() {
        return this.mofId.hashCode();
    }

    public final RefObject refMetaObject() {
        this._lock(false);
        try {
            RefObject refObject = (RefObject)this._getRepository().getHandler(this._getDelegate().getMetaObject());
            Object var2_2 = null;
            this._unlock();
            return refObject;
        }
        catch (StorageException e) {
            try {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this._unlock();
                throw throwable;
            }
        }
    }

    public final RefPackage refImmediatePackage() {
        this._lock(false);
        try {
            RefPackage refPackage = (RefPackage)this._getRepository().getHandler(this._getDelegate().getImmediatePackage());
            Object var2_2 = null;
            this._unlock();
            return refPackage;
        }
        catch (StorageException e) {
            try {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this._unlock();
                throw throwable;
            }
        }
    }

    public final RefPackage refOutermostPackage() {
        StorablePackage pkg;
        block5: {
            this._lock(false);
            pkg = this._getDelegate().getOutermostPackage();
            if (!pkg.getMofId().equals(this._getDelegate().getMofId())) break block5;
            RefPackage refPackage = (RefPackage)this;
            Object var2_5 = null;
            this._unlock();
            return refPackage;
        }
        try {
            RefPackage refPackage = (RefPackage)this._getRepository().getHandler(pkg);
            Object var2_6 = null;
            this._unlock();
            return refPackage;
        }
        catch (StorageException e) {
            try {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var2_7 = null;
                this._unlock();
                throw throwable;
            }
        }
    }

    public final String refMofId() {
        return this.mofId.toString();
    }

    public final Collection refVerifyConstraints(boolean deepVerify) {
        block3: {
            this._lock(false);
            try {
                if (!deepVerify) break block3;
                Collection collection = this._recursiveVerify(new ArrayList(), new HashSet());
                Object var2_4 = null;
                this._unlock();
                return collection;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                this._unlock();
                throw throwable;
            }
        }
        Collection collection = this._verify(new ArrayList());
        Object var2_5 = null;
        this._unlock();
        return collection;
    }

    public final StorableBaseObject _getDelegate() {
        try {
            StorableBaseObject result = this.storable != null ? this.storable : this.mdrStorage.getObject(this.mofId);
            if (result == null) {
                Exception exc = (Exception)deletedInstances.get(this);
                if (exc != null) {
                    Logger.getDefault().notify(1, (Throwable)exc);
                }
                throw new InvalidObjectException(null, "Object with MOFID " + this.mofId + " no longer exists, class: " + this.getClass().getName());
            }
            return result;
        }
        catch (StorageBadRequestException e) {
            Exception exc = (Exception)deletedInstances.get(this);
            if (exc != null) {
                Logger.getDefault().notify(1, (Throwable)exc);
            }
            throw new InvalidObjectException(null, "Object with MOFID " + this.mofId + " no longer exists, class: " + this.getClass().getName());
        }
        catch (StorageException e) {
            throw new DebugException(e.toString());
        }
    }

    public final MOFID _getMofId() {
        return this.mofId;
    }

    protected final void _setDelegate(StorableBaseObject storable) {
        boolean register = false;
        MOFID newMofId = storable.getMofId();
        if (this.mofId != null && !this.mofId.equals(newMofId)) {
            this._getRepository().removeHandler(this.mofId);
            register = true;
        }
        this.mofId = newMofId;
        this.storable = storable instanceof StorableObject && storable instanceof Transient ? storable : null;
        if (register) {
            this._getRepository().addHandler(this);
        }
    }

    protected final MdrStorage _getMdrStorage() {
        return this.mdrStorage;
    }

    protected final NBMDRepositoryImpl _getRepository() {
        return this.mdrStorage.getRepository();
    }

    protected abstract Collection _recursiveVerify(Collection var1, Set var2);

    protected abstract Collection _verify(Collection var1);
}

