/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers.gen;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.jmi.model.MultiplicityType;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public class TagSupport {
    public static final String TAGID_PACKAGE_PREFIX = "javax.jmi.packagePrefix";
    public static final String TAGID_SUBSTITUTE_NAME = "javax.jmi.substituteName";
    public static final String TAGID_IMPL_PACKAGE_PREFIX = "org.netbeans.implPackagePrefix";
    public static final int ASSOCIATION = 0;
    public static final int INSTANCE = 1;
    public static final int CLASS = 2;
    public static final int PACKAGE = 3;
    private static final Hashtable valueCache = new Hashtable();

    private TagSupport() {
    }

    public static String getTypeFullName(StorableObject type) {
        return TagSupport.getTypeFullName(type, TagSupport.getSubstName(type));
    }

    public static String getTypeFullName(StorableObject type, String substName) {
        return TagSupport.getTypePrefix(type, new StringBuffer(50)).append('.').append(substName).toString();
    }

    public static String getTypeFullName(StorableObject storable, int type) {
        return TagSupport.getTypePrefix(storable, new StringBuffer(50)).append('.').append(TagSupport.getSubstName(storable)).append(type == 2 ? "Class" : (type == 3 ? "Package" : "")).toString();
    }

    public static String getImplFullName(StorableObject storable, int type) {
        return TagSupport.getImplPrefix(storable, new StringBuffer(50)).append('.').append(TagSupport.getSubstName(storable)).append(type == 2 ? "Class" : (type == 3 ? "Package" : "")).append("Impl").toString();
    }

    public static StorableObject getTag(StorableObject storable, String tagID) {
        StorableObject tag = null;
        try {
            Collection tags = (Collection)storable.getImmediatePackage().getAssociation("AttachesTo").queryObjects("modelElement", storable.getMofId());
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                StorableObject temp = (StorableObject)it.next();
                if (!tagID.equals(temp.getAttribute("tagId"))) continue;
                tag = temp;
                break;
            }
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        return tag;
    }

    public static Collection getTagValues(StorableObject storable, String tagID) {
        StorableObject tag;
        block3: {
            tag = TagSupport.getTag(storable, tagID);
            try {
                if (tag != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        return (Collection)tag.getAttribute("values");
    }

    public static String getTagValue(StorableObject storable, String tagID) {
        if (storable == null) {
            return null;
        }
        CacheKey tagKey = new CacheKey(storable.getMofId(), tagID);
        String value = (String)valueCache.get(tagKey);
        if (value == null) {
            try {
                Collection values = TagSupport.getTagValues(storable, tagID);
                if (values != null && values.size() > 0) {
                    value = (String)values.iterator().next();
                    valueCache.put(tagKey, value);
                }
            }
            catch (Exception e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        return value;
    }

    public static String getTagValue(StorableObject storable, String tagID, String defaultValue) {
        String result = TagSupport.getTagValue(storable, tagID);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static String getDataTypeName(StorableObject type) {
        block6: {
            try {
                String typeName = (String)type.getMetaObject().getAttribute("name");
                if (typeName.equals("PrimitiveType")) {
                    return "java.lang." + (String)type.getAttribute("name");
                }
                if (typeName.equals("AliasType")) {
                    return TagSupport.getDataTypeName((StorableObject)type.getReference("type"));
                }
                if (!typeName.equals("CollectionType")) break block6;
                MultiplicityType multiplicity = (MultiplicityType)type.getAttribute("multiplicity");
                if (multiplicity.isOrdered()) {
                    return "java.util.List";
                }
                return "java.util.Collection";
            }
            catch (Exception e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        return TagSupport.getTypeFullName(type);
    }

    public static String getSubstName(StorableObject storable) {
        return TagSupport.getSubstName(storable, null, null);
    }

    public static String getSubstName(StorableObject storable, String name, String meta) {
        String result = TagSupport.getTagValue(storable, TAGID_SUBSTITUTE_NAME);
        try {
            if (result == null) {
                result = name == null ? (String)storable.getAttribute("name") : name;
            }
            if (meta == null) {
                meta = (String)storable.getMetaObject().getAttribute("name");
            }
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        if ("Constant".equals(meta)) {
            result = TagSupport.mapName(result, true, false);
        } else {
            boolean flag = "Class".equals(meta) || "Package".equals(meta) || "Association".equals(meta) || "Exception".equals(meta) || "Import".equals(meta) || "StructureType".equals(meta) || "EnumerationType".equals(meta) || "CollectionType".equals(meta);
            result = TagSupport.mapName(result, false, !flag);
            if ("Exception".equals(meta) && !result.endsWith("Exception")) {
                result = String.valueOf(result) + "Exception";
            }
        }
        return result;
    }

    private static String mapName(String name, boolean toLiteral, boolean firstLower) {
        StringBuffer buffer = new StringBuffer(32);
        boolean wordRead = false;
        boolean lowerCharDetected = false;
        int x = 0;
        while (x < name.length()) {
            char c = name.charAt(x);
            if (c == '-' || c == '_' || Character.isWhitespace(c)) {
                if (wordRead) {
                    if (toLiteral) {
                        buffer.append('_');
                    }
                    wordRead = false;
                    lowerCharDetected = false;
                }
            } else {
                if (lowerCharDetected && Character.isUpperCase(c)) {
                    if (toLiteral) {
                        buffer.append('_');
                    }
                    wordRead = false;
                    lowerCharDetected = false;
                } else if (Character.isLowerCase(c)) {
                    lowerCharDetected = true;
                }
                if (!wordRead || toLiteral) {
                    buffer.append(Character.toUpperCase(c));
                } else {
                    buffer.append(Character.toLowerCase(c));
                }
                wordRead = true;
            }
            ++x;
        }
        if (buffer.length() > 0) {
            if (toLiteral && !wordRead) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            if (firstLower) {
                buffer.replace(0, 1, new String(new char[]{Character.toLowerCase(buffer.charAt(0))}));
            }
        }
        return buffer.toString();
    }

    public static String mapEnumLiteral(String name) {
        return TagSupport.mapName(name, true, false);
    }

    private static StringBuffer getImplPrefix(StorableObject storable, StringBuffer sb) {
        try {
            StorableObject pckg = storable;
            while (!"Package".equals(pckg.getMetaObject().getAttribute("name"))) {
                pckg = (StorableObject)pckg.getReference("container");
            }
            StorableObject container = (StorableObject)pckg.getReference("container");
            if (container == null) {
                String result = TagSupport.getTagValue(pckg, TAGID_IMPL_PACKAGE_PREFIX);
                if (result == null) {
                    result = TagSupport.getTagValue(pckg, TAGID_PACKAGE_PREFIX);
                    if (result == null) {
                        sb.append("impl");
                    } else if ("javax.jmi".equals(result = result.toLowerCase(Locale.US))) {
                        sb.append("org.netbeans.jmiimpl.mof");
                    } else if (result.startsWith("org.netbeans.jmi.")) {
                        sb.append("org.netbeans.jmiimpl").append(result.substring(16));
                    } else if (result.startsWith("org.omg")) {
                        if (result.length() == 7) {
                            sb.append("org.netbeans.jmiimpl.omg");
                        } else if (result.charAt(7) == '.') {
                            sb.append("org.netbeans.jmiimpl.omg").append(result.substring(7));
                        } else {
                            sb.append(result).append(".impl");
                        }
                    } else {
                        sb.append(result).append(".impl");
                    }
                } else {
                    sb.append(result.toLowerCase(Locale.US));
                }
            } else {
                TagSupport.getImplPrefix(container, sb);
            }
            String packageName = TagSupport.getTagValue(pckg, TAGID_SUBSTITUTE_NAME);
            if (packageName == null) {
                packageName = TagSupport.mapName((String)pckg.getAttribute("name"), false, true);
            }
            sb.append('.').append(packageName.toLowerCase(Locale.US));
            return sb;
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public static String getTypePrefix(StorableObject storable) {
        return TagSupport.getTypePrefix(storable, new StringBuffer(50)).toString();
    }

    public static StringBuffer getTypePrefix(StorableObject storable, StringBuffer sb) {
        try {
            String packageName;
            StorableObject pckg = storable;
            while (!"Package".equals(pckg.getMetaObject().getAttribute("name"))) {
                pckg = (StorableObject)pckg.getReference("container");
            }
            StorableObject container = (StorableObject)pckg.getReference("container");
            if (container == null) {
                String result = TagSupport.getTagValue(pckg, TAGID_PACKAGE_PREFIX);
                if (result != null) {
                    sb.append(result.toLowerCase(Locale.US)).append('.');
                }
            } else {
                TagSupport.getTypePrefix(container, sb).append('.');
            }
            if ((packageName = TagSupport.getTagValue(pckg, TAGID_SUBSTITUTE_NAME)) == null) {
                packageName = TagSupport.mapName((String)pckg.getAttribute("name"), false, true);
            }
            return sb.append(packageName.toLowerCase(Locale.US));
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    private static class CacheKey {
        private final MOFID mofId;
        private final String tagId;

        public CacheKey(MOFID mofId, String tagId) {
            if (mofId == null) {
                throw new IllegalArgumentException();
            }
            this.mofId = mofId;
            this.tagId = tagId == null ? "null" : tagId;
        }

        public boolean equals(Object o) {
            return o instanceof CacheKey && ((CacheKey)o).mofId.equals(this.mofId) && ((CacheKey)o).tagId.equals(this.tagId);
        }

        public int hashCode() {
            return this.mofId.hashCode() * 31 + this.tagId.hashCode();
        }
    }
}

