/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDataFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPageInputStream;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.DeletedBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntHolder;
import org.netbeans.mdr.util.Logger;

abstract class ActiveBtreeExtent
extends BtreeExtent {
    int dataLength;
    int dataStart;

    ActiveBtreeExtent(DeletedBtreeExtent del) {
        super(del);
        this.headerIsDirty = true;
    }

    ActiveBtreeExtent(BtreeDataFile file, int chunkNum, short numChunks) {
        super(file, chunkNum, numChunks);
    }

    abstract int getMyDataLength();

    abstract int setMyDataLength(int var1);

    abstract int getAvailableDataLength();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeData(byte[] dataBuffer, int dataOffset) throws StorageException {
        toCopy = this.dataLength;
        offst = new IntHolder();
        numChunks = (this.dataStart + toCopy - 1) / 32 + 1;
        if (numChunks > this.chunks) {
            se = new StoragePersistentDataException("Number of chunks does not match.");
            Logger.getDefault().annotate((Throwable)se, "Bad number of chunks: ----------------------");
            Logger.getDefault().annotate((Throwable)se, "start chunk number: " + this.myChunkNum);
            Logger.getDefault().annotate((Throwable)se, "#chunks: " + this.chunks + " computed #chunks: " + numChunks);
            Logger.getDefault().annotate((Throwable)se, "dataLength: " + this.dataLength + " dataSart: " + this.dataStart);
            throw se;
        }
        pages = this.owner.getChunks(this.myChunkNum, numChunks, offst);
        try {
            pageNum = 0;
            pageSize = pages[0].contents.length;
            offset = offst.getValue() + this.dataStart;
            while (offset >= pageSize) {
                ++pageNum;
                offset -= pageSize;
            }
            while (toCopy > 0) {
                thisPage = Math.min(pageSize - offset, toCopy);
                pages[pageNum].setWritable();
                System.arraycopy(dataBuffer, dataOffset, pages[pageNum].contents, offset, thisPage);
                dataOffset += thisPage;
                toCopy -= thisPage;
                ++pageNum;
                offset = 0;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var12_12) {
            var11_13 = null;
            i = 0;
        }
        while (true) {
            if (i >= pages.length) {
                throw var12_12;
            }
            pages[i].unpin();
            ++i;
        }
lbl-1000:
        // 1 sources

        {
            var11_14 = null;
            i = 0;
        }
        while (true) {
            if (i >= pages.length) {
                return;
            }
            pages[i].unpin();
            ++i;
        }
    }

    void addToStream(CachedPageInputStream strm) throws StorageException {
        IntHolder offst = new IntHolder();
        int toAppend = this.getMyDataLength();
        int numChunks = (this.dataStart + toAppend - 1) / 32 + 1;
        CachedPage[] pages = this.owner.getChunks(this.myChunkNum, numChunks, offst);
        if (numChunks > this.chunks) {
            StoragePersistentDataException se = new StoragePersistentDataException("Number of chunks does not match.");
            Logger.getDefault().annotate((Throwable)se, "Bad number of chunks: ----------------------");
            Logger.getDefault().annotate((Throwable)se, "start chunk number: " + this.myChunkNum);
            Logger.getDefault().annotate((Throwable)se, "#chunks: " + this.chunks + " computed #chunks: " + numChunks);
            Logger.getDefault().annotate((Throwable)se, "dataLength: " + this.dataLength + " dataSart: " + this.dataStart);
            throw se;
        }
        int pageNum = 0;
        int pageSize = pages[0].contents.length;
        int offset = offst.getValue() + this.dataStart;
        while (offset >= pageSize) {
            ++pageNum;
            offset -= pageSize;
        }
        while (pageNum < pages.length) {
            int thisPage = Math.min(pageSize - offset, toAppend);
            strm.addPage(pages[pageNum], offset, thisPage);
            offset = 0;
            toAppend -= thisPage;
            ++pageNum;
        }
        while (pageNum < pages.length) {
            pages[pageNum].unpin();
            ++pageNum;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getCRC() throws StorageException {
        CachedPageInputStream dstrm = new CachedPageInputStream();
        FilterInputStream cis = null;
        try {
            long l;
            block6: {
                try {
                    this.addToStream(dstrm);
                    cis = new CheckedInputStream(dstrm, new CRC32());
                    while (((CheckedInputStream)cis).read() >= 0) {
                    }
                    l = ((CheckedInputStream)cis).getChecksum().getValue();
                    Object var3_4 = null;
                    if (cis == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (cis != null) {
                        cis.close();
                        throw throwable;
                    }
                    dstrm.close();
                    throw throwable;
                }
                cis.close();
                return l;
            }
            dstrm.close();
            return l;
        }
        catch (IOException exc) {
            throw new StorageIOException(exc);
        }
    }

    abstract boolean isMaximum();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dump(int level, PrintWriter strm) throws StorageException {
        super.dump(level, strm);
        boolean dumpData = (level & 4) != 0;
        boolean showCheckSum = (level & 8) != 0;
        strm.println(this.dataLength + " data bytes");
        if (dumpData) {
            CachedPageInputStream dstrm = new CachedPageInputStream();
            try {
                try {
                    this.addToStream(dstrm);
                    if (dumpData) {
                        ActiveBtreeExtent.dumpBytesAsHex(dstrm, strm, "\t");
                        strm.println();
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    dstrm.close();
                    throw throwable;
                }
                {
                    Object var6_8 = null;
                    dstrm.close();
                }
            }
            catch (IOException exc) {
                throw new StorageIOException(exc);
            }
        }
        if (showCheckSum) {
            strm.println("Data checksum: " + this.getCRC());
            strm.println();
        }
    }
}

