/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.enumerable.AggContext;
import org.apache.calcite.adapter.enumerable.AggImpState;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.enumerable.impl.AggAddContextImpl;
import org.apache.calcite.adapter.enumerable.impl.AggResultContextImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerableAggregate
extends Aggregate
implements EnumerableRel {
    public EnumerableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traitSet, child, indicator, groupSet, groupSets, aggCalls);
        assert (this.getConvention() instanceof EnumerableConvention);
        for (AggregateCall aggCall : aggCalls) {
            if (aggCall.isDistinct()) {
                throw new InvalidRelException("distinct aggregation not supported");
            }
            AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation(), false);
            if (implementor2 != null) continue;
            throw new InvalidRelException("aggregation " + aggCall.getAggregation() + " not supported");
        }
    }

    @Override
    public EnumerableAggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new EnumerableAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        ParameterExpression key_;
        final JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        Expression childExp = builder.append("child", result.block);
        final RelDataType inputRowType = this.getInput().getRowType();
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.preferCustom());
        final PhysType inputPhysType = result.physType;
        ParameterExpression parameter = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"a0");
        PhysType keyPhysType = inputPhysType.project(this.groupSet.asList(), this.getGroupType() != Aggregate.Group.SIMPLE, JavaRowFormat.LIST);
        int groupCount = this.getGroupCount();
        int indicatorCount = this.getIndicatorCount();
        ArrayList<AggImpState> aggs = new ArrayList<AggImpState>(this.aggCalls.size());
        for (int i = 0; i < this.aggCalls.size(); ++i) {
            AggregateCall call = (AggregateCall)this.aggCalls.get(i);
            aggs.add(new AggImpState(i, call, false));
        }
        ArrayList<Expression> initExpressions = new ArrayList<Expression>();
        BlockBuilder initBlock = new BlockBuilder();
        ArrayList<Type> aggStateTypes = new ArrayList<Type>();
        for (final AggImpState agg : aggs) {
            agg.context = new AggContext(){

                @Override
                public SqlAggFunction aggregation() {
                    return agg.call.getAggregation();
                }

                @Override
                public RelDataType returnRelType() {
                    return agg.call.type;
                }

                @Override
                public Type returnType() {
                    return EnumUtils.javaClass(typeFactory, this.returnRelType());
                }

                @Override
                public List<? extends RelDataType> parameterRelTypes() {
                    return EnumUtils.fieldRowTypes(inputRowType, null, agg.call.getArgList());
                }

                @Override
                public List<? extends Type> parameterTypes() {
                    return EnumUtils.fieldTypes(typeFactory, this.parameterRelTypes());
                }
            };
            List<Type> state = agg.implementor.getStateType(agg.context);
            if (state.isEmpty()) continue;
            aggStateTypes.addAll(state);
            ArrayList<Expression> decls = new ArrayList<Expression>(state.size());
            for (int i = 0; i < state.size(); ++i) {
                String aggName = "a" + agg.aggIdx;
                if (CalcitePrepareImpl.DEBUG) {
                    aggName = Util.toJavaId(agg.call.getAggregation().getName(), 0).substring("ID$0$".length()) + aggName;
                }
                Type type = state.get(i);
                ParameterExpression pe = Expressions.parameter((Type)type, (String)initBlock.newName(aggName + "s" + i));
                initBlock.add((Statement)Expressions.declare((int)0, (ParameterExpression)pe, null));
                decls.add((Expression)pe);
            }
            agg.state = decls;
            initExpressions.addAll(decls);
            agg.implementor.implementReset(agg.context, new AggResultContextImpl(initBlock, decls));
        }
        PhysType accPhysType = PhysTypeImpl.of(typeFactory, typeFactory.createSyntheticType(aggStateTypes));
        initBlock.add(accPhysType.record(initExpressions));
        Expression accumulatorInitializer = builder.append("accumulatorInitializer", (Expression)Expressions.lambda(Function0.class, (BlockStatement)initBlock.toBlock(), (ParameterExpression[])new ParameterExpression[0]));
        BlockBuilder builder2 = new BlockBuilder();
        final ParameterExpression inParameter = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"in");
        ParameterExpression acc_ = Expressions.parameter((Type)accPhysType.getJavaRowType(), (String)"acc");
        int stateOffset = 0;
        for (int i = 0; i < aggs.size(); ++i) {
            final AggImpState agg = (AggImpState)aggs.get(i);
            int stateSize = agg.state.size();
            ArrayList<Expression> accumulator = new ArrayList<Expression>(stateSize);
            for (int j = 0; j < stateSize; ++j) {
                accumulator.add(accPhysType.fieldReference((Expression)acc_, j + stateOffset));
            }
            agg.state = accumulator;
            stateOffset += stateSize;
            AggAddContextImpl addContext = new AggAddContextImpl(builder2, accumulator){

                @Override
                public List<RexNode> rexArguments() {
                    List<RelDataTypeField> inputTypes = inputPhysType.getRowType().getFieldList();
                    ArrayList<RexNode> args = new ArrayList<RexNode>();
                    for (Integer index : agg.call.getArgList()) {
                        args.add(new RexInputRef(index, inputTypes.get(index).getType()));
                    }
                    return args;
                }

                @Override
                public RexToLixTranslator rowTranslator() {
                    return RexToLixTranslator.forAggregation(typeFactory, this.currentBlock(), new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(inParameter, inputPhysType)))).setNullable(this.currentNullables());
                }
            };
            agg.implementor.implementAdd(agg.context, addContext);
        }
        builder2.add((Expression)acc_);
        Expression accumulatorAdder = builder.append("accumulatorAdder", (Expression)Expressions.lambda(Function2.class, (BlockStatement)builder2.toBlock(), (ParameterExpression[])new ParameterExpression[]{acc_, inParameter}));
        BlockBuilder resultBlock = new BlockBuilder();
        Expressions.FluentList results = Expressions.list();
        if (groupCount == 0) {
            key_ = null;
        } else {
            Type keyType = keyPhysType.getJavaRowType();
            key_ = Expressions.parameter((Type)keyType, (String)"key");
            for (int j = 0; j < groupCount + indicatorCount; ++j) {
                results.add(keyPhysType.fieldReference((Expression)key_, j));
            }
        }
        for (AggImpState agg : aggs) {
            results.add(agg.implementor.implementResult(agg.context, new AggResultContextImpl(resultBlock, agg.state)));
        }
        resultBlock.add(physType.record((List<Expression>)results));
        if (this.getGroupType() != Aggregate.Group.SIMPLE) {
            ArrayList list = Lists.newArrayList();
            for (ImmutableBitSet set : this.groupSets) {
                list.add(inputPhysType.generateSelector(parameter, this.groupSet.toList(), set.toList(), keyPhysType.getFormat()));
            }
            Expression keySelectors_ = builder.append("keySelectors", (Expression)Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Iterable)list));
            Expression resultSelector = builder.append("resultSelector", (Expression)Expressions.lambda(Function2.class, (BlockStatement)resultBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{key_, acc_}));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.GROUP_BY_MULTIPLE.method, (Iterable)Expressions.list((Object[])new Expression[]{childExp, keySelectors_, accumulatorInitializer, accumulatorAdder, resultSelector}).appendIfNotNull((Object)keyPhysType.comparer()))));
        } else if (groupCount == 0) {
            Expression resultSelector = builder.append("resultSelector", (Expression)Expressions.lambda(Function1.class, (BlockStatement)resultBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{acc_}));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.SINGLETON_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.call((Expression)childExp, (Method)BuiltInMethod.AGGREGATE.method, (Expression[])new Expression[]{Expressions.call((Expression)accumulatorInitializer, (String)"apply", (Expression[])new Expression[0]), accumulatorAdder, resultSelector})})));
        } else if (this.aggCalls.isEmpty() && this.groupSet.equals(ImmutableBitSet.range(child.getRowType().getFieldCount()))) {
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)inputPhysType.convertTo(childExp, physType), (Method)BuiltInMethod.DISTINCT.method, (Iterable)Expressions.list().appendIfNotNull((Object)physType.comparer()))));
        } else {
            Expression keySelector_ = builder.append("keySelector", inputPhysType.generateSelector(parameter, this.groupSet.toList(), keyPhysType.getFormat()));
            Expression resultSelector_ = builder.append("resultSelector", (Expression)Expressions.lambda(Function2.class, (BlockStatement)resultBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{key_, acc_}));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)childExp, (Method)BuiltInMethod.GROUP_BY2.method, (Iterable)Expressions.list((Object[])new Expression[]{keySelector_, accumulatorInitializer, accumulatorAdder, resultSelector_}).appendIfNotNull((Object)keyPhysType.comparer()))));
        }
        return implementor.result(physType, builder.toBlock());
    }
}

