/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Enumerables;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableScanNode
implements Node {
    private final Sink sink;
    private final TableScan rel;
    private final ImmutableList<RexNode> filters;
    private final DataContext root;
    private final int[] projects;

    TableScanNode(Interpreter interpreter, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects) {
        this.rel = rel;
        this.filters = (ImmutableList)Preconditions.checkNotNull(filters);
        this.projects = projects == null ? null : projects.toIntArray();
        this.sink = interpreter.sink(rel);
        this.root = interpreter.getDataContext();
    }

    @Override
    public void run() throws InterruptedException {
        Enumerable<Row> iterable = this.iterable();
        Enumerator enumerator = iterable.enumerator();
        while (enumerator.moveNext()) {
            this.sink.send((Row)enumerator.current());
        }
        enumerator.close();
        this.sink.end();
    }

    private Enumerable<Row> iterable() {
        RelOptTable table = this.rel.getTable();
        ProjectableFilterableTable pfTable = table.unwrap(ProjectableFilterableTable.class);
        if (pfTable != null) {
            ArrayList filters1 = Lists.newArrayList(this.filters);
            int[] projects1 = this.projects == null || TableScanNode.isIdentity(this.projects, this.rel.getRowType().getFieldCount()) ? null : this.projects;
            Enumerable<Object[]> enumerator = pfTable.scan(this.root, filters1, projects1);
            assert (filters1.isEmpty()) : "table could not handle a filter it earlier said it could";
            return Enumerables.toRow(enumerator);
        }
        if (this.projects != null) {
            throw new AssertionError((Object)"have projects, but table cannot handle them");
        }
        FilterableTable filterableTable = table.unwrap(FilterableTable.class);
        if (filterableTable != null) {
            ArrayList filters1 = Lists.newArrayList(this.filters);
            Enumerable<Object[]> enumerator = filterableTable.scan(this.root, filters1);
            assert (filters1.isEmpty()) : "table could not handle a filter it earlier said it could";
            return Enumerables.toRow(enumerator);
        }
        if (!this.filters.isEmpty()) {
            throw new AssertionError((Object)"have filters, but table cannot handle them");
        }
        ScannableTable scannableTable = table.unwrap(ScannableTable.class);
        if (scannableTable != null) {
            return Enumerables.toRow(scannableTable.scan(this.root));
        }
        Enumerable iterable = table.unwrap(Enumerable.class);
        if (iterable != null) {
            return iterable;
        }
        QueryableTable queryableTable = table.unwrap(QueryableTable.class);
        if (queryableTable != null) {
            Type elementType = queryableTable.getElementType();
            SchemaPlus schema = this.root.getRootSchema();
            for (String name : Util.skipLast(table.getQualifiedName())) {
                schema = schema.getSubSchema(name);
            }
            if (elementType instanceof Class) {
                Queryable queryable = Schemas.queryable(this.root, (Class)elementType, table.getQualifiedName());
                ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                Class type = (Class)elementType;
                for (Field field : type.getFields()) {
                    if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                    fieldBuilder.add((Object)field);
                }
                ImmutableList fields = fieldBuilder.build();
                return queryable.select((Function1)new Function1<Object, Row>((List)fields){
                    final /* synthetic */ List val$fields;
                    {
                        this.val$fields = list;
                    }

                    public Row apply(Object o) {
                        Object[] values = new Object[this.val$fields.size()];
                        for (int i = 0; i < this.val$fields.size(); ++i) {
                            Field field = (Field)this.val$fields.get(i);
                            try {
                                values[i] = field.get(o);
                                continue;
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return new Row(values);
                    }
                });
            }
            return Schemas.queryable(this.root, Row.class, table.getQualifiedName());
        }
        throw new AssertionError((Object)("cannot convert table " + table + " to iterable"));
    }

    private static boolean isIdentity(int[] is, int count) {
        if (is.length != count) {
            return false;
        }
        for (int i = 0; i < is.length; ++i) {
            if (is[i] == i) continue;
            return false;
        }
        return true;
    }
}

