/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.jdbc.CalciteRootSchema;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.MaterializationKey;
import org.apache.calcite.materialize.TileKey;
import org.apache.calcite.rel.type.RelDataType;

class MaterializationActor {
    final Map<MaterializationKey, Materialization> keyMap = Maps.newHashMap();
    final Map<QueryKey, MaterializationKey> keyBySql = Maps.newHashMap();
    final Map<TileKey, MaterializationKey> keyByTile = Maps.newHashMap();
    final Multimap<TileKey, TileKey> tilesByDimensionality = HashMultimap.create();

    MaterializationActor() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueryKey {
        final String sql;
        final CalciteSchema schema;
        final List<String> path;

        QueryKey(String sql, CalciteSchema schema, List<String> path) {
            this.sql = sql;
            this.schema = schema;
            this.path = path;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof QueryKey && this.sql.equals(((QueryKey)obj).sql) && this.schema.equals(((QueryKey)obj).schema) && this.path.equals(((QueryKey)obj).path);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.sql, this.schema, this.path});
        }
    }

    static class Materialization {
        final MaterializationKey key;
        final CalciteRootSchema rootSchema;
        CalciteSchema.TableEntry materializedTable;
        final String sql;
        final RelDataType rowType;

        Materialization(MaterializationKey key, CalciteRootSchema rootSchema, CalciteSchema.TableEntry materializedTable, String sql, RelDataType rowType) {
            this.key = key;
            this.rootSchema = rootSchema;
            this.materializedTable = materializedTable;
            this.sql = sql;
            this.rowType = rowType;
        }
    }
}

