/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.hep;

import java.util.List;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HepRelVertex
extends AbstractRelNode {
    private RelNode currentRel;

    HepRelVertex(RelNode rel) {
        super(rel.getCluster(), rel.getTraitSet());
        this.currentRel = rel;
    }

    @Override
    public void explain(RelWriter pw) {
        this.currentRel.explain(pw);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.equals(this.traitSet));
        assert (inputs.equals(this.getInputs()));
        return this;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        throw Util.newInternal("should never get here");
    }

    @Override
    public double getRows() {
        return RelMetadataQuery.getRowCount(this.currentRel);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.currentRel.getRowType();
    }

    @Override
    public boolean isDistinct() {
        return this.currentRel.isDistinct();
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        return this.currentRel.isKey(columns);
    }

    @Override
    protected String computeDigest() {
        return "HepRelVertex(" + this.currentRel + ")";
    }

    void replaceRel(RelNode newRel) {
        this.currentRel = newRel;
    }

    public RelNode getCurrentRel() {
        return this.currentRel;
    }
}

