/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogicalJoin
extends Join {
    private final boolean semiJoinDone;
    private final ImmutableList<RelDataTypeField> systemFieldList;

    public LogicalJoin(RelOptCluster cluster, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
        this(cluster, left, right, condition, joinType, variablesStopped, false, (ImmutableList<RelDataTypeField>)ImmutableList.of());
    }

    public LogicalJoin(RelOptCluster cluster, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone, ImmutableList<RelDataTypeField> systemFieldList) {
        super(cluster, cluster.traitSetOf(Convention.NONE), left, right, condition, joinType, variablesStopped);
        assert (systemFieldList != null);
        this.semiJoinDone = semiJoinDone;
        this.systemFieldList = systemFieldList;
    }

    public LogicalJoin(RelInput input) {
        this(input.getCluster(), input.getInputs().get(0), input.getInputs().get(1), input.getExpression("condition"), input.getEnum("joinType", JoinRelType.class), (Set<String>)ImmutableSet.of(), false, (ImmutableList<RelDataTypeField>)ImmutableList.of());
    }

    @Override
    public LogicalJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new LogicalJoin(this.getCluster(), left, right, conditionExpr, joinType, (Set<String>)this.variablesStopped, semiJoinDone, this.systemFieldList);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("semiJoinDone", this.semiJoinDone, this.semiJoinDone);
    }

    @Override
    public boolean isSemiJoinDone() {
        return this.semiJoinDone;
    }

    @Override
    public List<RelDataTypeField> getSystemFieldList() {
        return this.systemFieldList;
    }
}

