/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataFactory;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataFactoryImpl
implements MetadataFactory {
    public static final Function<RelNode, Metadata> DUMMY = Functions.constant(null);
    private final LoadingCache<Pair<Class<RelNode>, Class<Metadata>>, Function<RelNode, Metadata>> cache;

    public MetadataFactoryImpl(RelMetadataProvider provider) {
        this.cache = CacheBuilder.newBuilder().build(MetadataFactoryImpl.loader(provider));
    }

    static CacheLoader<Pair<Class<RelNode>, Class<Metadata>>, Function<RelNode, Metadata>> loader(final RelMetadataProvider provider) {
        return new CacheLoader<Pair<Class<RelNode>, Class<Metadata>>, Function<RelNode, Metadata>>(){

            public Function<RelNode, Metadata> load(Pair<Class<RelNode>, Class<Metadata>> key) throws Exception {
                Function<RelNode, Metadata> function = provider.apply((Class)key.left, (Class)key.right);
                return function != null ? function : DUMMY;
            }
        };
    }

    @Override
    public <T extends Metadata> T query(RelNode rel, Class<T> clazz) {
        try {
            Pair<Class<?>, Class<T>> key = Pair.of(rel.getClass(), clazz);
            Metadata apply = (Metadata)((Function)this.cache.get(key)).apply((Object)rel);
            return (T)apply;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw (Error)e.getCause();
        }
    }
}

