/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterProjectTransposeRule
extends RelOptRule {
    public static final FilterProjectTransposeRule INSTANCE = new FilterProjectTransposeRule(Filter.class, null, Project.class, null);
    private final RelFactories.FilterFactory filterFactory;
    private final RelFactories.ProjectFactory projectFactory;

    public FilterProjectTransposeRule(Class<? extends Filter> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends Project> projectClass, RelFactories.ProjectFactory projectFactory) {
        super(FilterProjectTransposeRule.operand(filterClass, FilterProjectTransposeRule.operand(projectClass, FilterProjectTransposeRule.any()), new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
        this.projectFactory = projectFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Project project = (Project)call.rel(1);
        if (RexOver.containsOver(project.getProjects(), null)) {
            return;
        }
        RexNode newCondition = RelOptUtil.pushFilterPastProject(filter.getCondition(), project);
        RelDataTypeFactory typeFactory = filter.getCluster().getTypeFactory();
        if (RexUtil.isNullabilityCast(typeFactory, newCondition)) {
            newCondition = ((RexCall)newCondition).getOperands().get(0);
        }
        RelNode newFilterRel = this.filterFactory == null ? filter.copy(filter.getTraitSet(), project.getInput(), newCondition) : this.filterFactory.createFilter(project.getInput(), newCondition);
        RelNode newProjRel = this.projectFactory == null ? project.copy(project.getTraitSet(), newFilterRel, project.getProjects(), project.getRowType()) : this.projectFactory.createProject(newFilterRel, project.getProjects(), project.getRowType().getFieldNames());
        call.transformTo(newProjRel);
    }
}

