/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public class SqlSubstringFunction
extends SqlFunction {
    SqlSubstringFunction() {
        super("SUBSTRING", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
    }

    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 2: {
                return "{0}({1} FROM {2})";
            }
            case 3: {
                return "{0}({1} FROM {2} FOR {3})";
            }
        }
        throw new AssertionError();
    }

    public String getAllowedSignatures(String opName) {
        StringBuilder ret = new StringBuilder();
        for (Ord typeName : Ord.zip(SqlTypeName.STRING_TYPES)) {
            if (typeName.i > 0) {
                ret.append(NL);
            }
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of((Object)typeName.e, (Object)((Object)SqlTypeName.INTEGER))));
            ret.append(NL);
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of((Object)typeName.e, (Object)((Object)SqlTypeName.INTEGER), (Object)((Object)SqlTypeName.INTEGER))));
        }
        return ret.toString();
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlCall call = callBinding.getCall();
        SqlValidator validator = callBinding.getValidator();
        SqlValidatorScope scope = callBinding.getScope();
        List<SqlNode> operands = call.getOperandList();
        int n = operands.size();
        assert (3 == n || 2 == n);
        if (!OperandTypes.STRING.checkSingleOperandType(callBinding, operands.get(0), 0, throwOnFailure)) {
            return false;
        }
        if (2 == n) {
            if (!OperandTypes.NUMERIC.checkSingleOperandType(callBinding, operands.get(1), 0, throwOnFailure)) {
                return false;
            }
        } else {
            RelDataType t1 = validator.deriveType(scope, operands.get(1));
            RelDataType t2 = validator.deriveType(scope, operands.get(2));
            if (SqlTypeUtil.inCharFamily(t1)) {
                if (!OperandTypes.STRING.checkSingleOperandType(callBinding, operands.get(1), 0, throwOnFailure)) {
                    return false;
                }
                if (!OperandTypes.STRING.checkSingleOperandType(callBinding, operands.get(2), 0, throwOnFailure)) {
                    return false;
                }
                if (!SqlTypeUtil.isCharTypeComparable(callBinding, operands, throwOnFailure)) {
                    return false;
                }
            } else {
                if (!OperandTypes.NUMERIC.checkSingleOperandType(callBinding, operands.get(1), 0, throwOnFailure)) {
                    return false;
                }
                if (!OperandTypes.NUMERIC.checkSingleOperandType(callBinding, operands.get(2), 0, throwOnFailure)) {
                    return false;
                }
            }
            if (!SqlTypeUtil.inSameFamily(t1, t2)) {
                if (throwOnFailure) {
                    throw callBinding.newValidationSignatureError();
                }
                return false;
            }
        }
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        if (3 == call.operandCount()) {
            writer.sep("FOR");
            ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }

    public SqlMonotonicity getMonotonicity(SqlCall call, SqlValidatorScope scope) {
        List<SqlNode> operands = call.getOperandList();
        if (operands.size() == 3) {
            SqlNode op0 = operands.get(0);
            SqlNode op1 = operands.get(1);
            SqlNode op2 = operands.get(2);
            SqlMonotonicity mono0 = op0.getMonotonicity(scope);
            if (mono0 != SqlMonotonicity.NOT_MONOTONIC && op1.getMonotonicity(scope) == SqlMonotonicity.CONSTANT && op1 instanceof SqlLiteral && ((SqlLiteral)op1).bigDecimalValue().equals(BigDecimal.ZERO) && op2.getMonotonicity(scope) == SqlMonotonicity.CONSTANT) {
                return mono0.unstrict();
            }
        }
        return super.getMonotonicity(call, scope);
    }
}

