/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class MapSqlType
extends AbstractSqlType {
    private final RelDataType keyType;
    private final RelDataType valueType;

    public MapSqlType(RelDataType keyType, RelDataType valueType, boolean isNullable) {
        super(SqlTypeName.MAP, isNullable, null);
        assert (keyType != null);
        assert (valueType != null);
        this.keyType = keyType;
        this.valueType = valueType;
        this.computeDigest();
    }

    public RelDataType getValueType() {
        return this.valueType;
    }

    public RelDataType getKeyType() {
        return this.keyType;
    }

    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("(").append(withDetail ? this.keyType.getFullTypeString() : this.keyType.toString()).append(", ").append(withDetail ? this.valueType.getFullTypeString() : this.valueType.toString()).append(") MAP");
    }

    public RelDataTypeFamily getFamily() {
        return this;
    }
}

