/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.dnd;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DragAndDropContainer
implements XMLInterface {
    public static final int TYPE_STEP = 1;
    public static final int TYPE_BASE_STEP_TYPE = 2;
    public static final int TYPE_DATABASE_CONNECTION = 3;
    public static final int TYPE_TRANS_HOP = 4;
    public static final int TYPE_TEXT = 5;
    public static final int TYPE_JOB_ENTRY = 6;
    public static final int TYPE_BASE_JOB_ENTRY = 7;
    public static final int TYPE_PHYSICAL_TABLE = 8;
    public static final int TYPE_PHYSICAL_COLUMN = 9;
    public static final int TYPE_BUSINESS_VIEW = 10;
    public static final int TYPE_BUSINESS_TABLE = 11;
    public static final int TYPE_BUSINESS_COLUMN = 12;
    public static final int TYPE_RELATIONSHIP = 13;
    public static final int TYPE_BUSINESS_MODEL = 14;
    private static final String[] typeCodes = new String[]{"", "Step", "BaseStep", "DatabaseConnection", "TransHop", "Text", "Jobentry", "BaseJobentry", "PhysicalTable", "PhysicalColumn", "BusinessView", "BusinessTable", "BusinessColumn", "Relationship", "Business Model"};
    private static final String XML_TAG = "DragAndDrop";
    private int type;
    private String data;

    public DragAndDropContainer(int type, String data) {
        this.type = type;
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getTypeCode() {
        if (this.type <= 0 || this.type >= typeCodes.length) {
            return null;
        }
        return typeCodes[this.type];
    }

    public static final int getType(String typeCode) {
        for (int i = 1; i < typeCodes.length; ++i) {
            if (!typeCodes[i].equals(typeCode)) continue;
            return i;
        }
        return 0;
    }

    public String getXML() {
        try {
            StringBuilder xml = new StringBuilder(100);
            xml.append(XMLHandler.getXMLHeader());
            xml.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
            xml.append("  ").append(XMLHandler.addTagValue((String)"DragType", (String)this.getTypeCode()));
            xml.append("  ").append(XMLHandler.addTagValue((String)"Data", (String)new String(Base64.encodeBase64((byte[])this.data.getBytes("UTF-8")))));
            xml.append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
            return xml.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to encode String in encoding [UTF-8]", e);
        }
    }

    public DragAndDropContainer(String xml) throws KettleXMLException {
        try {
            Document doc = XMLHandler.loadXMLString((String)xml);
            Node dnd = XMLHandler.getSubNode((Node)doc, (String)XML_TAG);
            this.type = DragAndDropContainer.getType(XMLHandler.getTagValue((Node)dnd, (String)"DragType"));
            this.data = new String(Base64.decodeBase64((byte[])XMLHandler.getTagValue((Node)dnd, (String)"Data").getBytes()), "UTF-8");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unexpected error parsing Drag & Drop XML fragment: " + xml, (Throwable)e);
        }
    }
}

