/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.dnd;

import org.apache.commons.codec.binary.Base64;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.dnd.DragAndDropContainer;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;

public class XMLTransfer
extends ByteArrayTransfer {
    private static final String MYTYPENAME = "KETTLE_XML_TRANSFER";
    private static final int MYTYPEID = XMLTransfer.registerType((String)"KETTLE_XML_TRANSFER");
    private static XMLTransfer _instance = new XMLTransfer();
    private LogChannelInterface log = new LogChannel((Object)"XML DND Transfer");

    private XMLTransfer() {
    }

    public static XMLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkMyType(object)) {
            return;
        }
        try {
            byte[] buffer = Base64.encodeBase64((byte[])((DragAndDropContainer)object).getXML().getBytes("UTF-8"));
            super.javaToNative((Object)buffer, transferData);
        }
        catch (Exception e) {
            this.log.logError("Unexpected error trying to put a string onto the XML Transfer type: " + e.toString());
            this.log.logError(Const.getStackTracker((Throwable)e));
            return;
        }
    }

    boolean checkMyType(Object object) {
        return object != null && object instanceof DragAndDropContainer;
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            try {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                String xml = new String(Base64.decodeBase64((byte[])new String(buffer).getBytes()));
                return new DragAndDropContainer(xml);
            }
            catch (Exception e) {
                this.log.logError("Unexpected error trying to read a drag and drop container from the XML Transfer type: " + e.toString());
                this.log.logError(Const.getStackTracker((Throwable)e));
                return null;
            }
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{MYTYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{MYTYPEID};
    }
}

