/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.ui.core.FormDataBuilder;

public abstract class WidgetUtils {
    private WidgetUtils() {
    }

    public static void setFormLayout(Composite composite, int margin) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = margin;
        formLayout.marginHeight = margin;
        composite.setLayout((Layout)formLayout);
    }

    public static CTabFolder createTabFolder(Composite composite, FormData fd, String ... titles) {
        Composite container = new Composite(composite, 0);
        WidgetUtils.setFormLayout(container, 0);
        container.setLayoutData((Object)fd);
        CTabFolder tabFolder = new CTabFolder(container, 0);
        tabFolder.setLayoutData((Object)new FormDataBuilder().fullSize().result());
        for (String title : titles) {
            if (title.length() < 8) {
                title = StringUtils.rightPad((String)title, (int)8);
            }
            Composite tab = new Composite((Composite)tabFolder, 0);
            WidgetUtils.setFormLayout(tab, 10);
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            tabItem.setText(title);
            tabItem.setControl((Control)tab);
        }
        tabFolder.setSelection(0);
        return tabFolder;
    }

    public static FormData firstColumn(Control top) {
        return new FormDataBuilder().top(top, 10).percentWidth(47).result();
    }

    public static FormData secondColumn(Control top) {
        return new FormDataBuilder().top(top, 10).right().left(53, 0).result();
    }
}

