/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.auth;

import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.auth.controller.AuthProviderController;
import org.pentaho.di.ui.core.auth.model.NamedProvider;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;

public class AuthProviderDialog {
    private static String XUL_FILE = "org/pentaho/di/ui/core/auth/xul/authManager.xul";
    private LogChannelInterface log;
    private AuthProviderController controller = new AuthProviderController();
    private XulDomContainer container;
    private static final Class<?> CLZ = AuthProviderDialog.class;
    private ResourceBundle resourceBundle = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)CLZ, (String)key, (String[])new String[0]);
        }
    };

    public AuthProviderDialog(Shell shell) {
        this.log = new LogChannel((Object)this.resourceBundle.getString("log.name"));
        try {
            SwtXulLoader xulLoader = new SwtXulLoader();
            xulLoader.setOuterContext((Object)shell);
            this.container = xulLoader.loadXul(XUL_FILE, (Object)this.resourceBundle);
            SwtXulRunner runner = new SwtXulRunner();
            runner.addContainer(this.container);
            SwtBindingFactory bf = new SwtBindingFactory();
            bf.setDocument(this.container.getDocumentRoot());
            this.controller.setBindingFactory((BindingFactory)bf);
            this.controller.setResourceBundle(this.resourceBundle);
            this.container.addEventHandler((XulEventHandler)this.controller);
            try {
                runner.initialize();
            }
            catch (XulException e) {
                SpoonFactory.getInstance().messageBox(e.getLocalizedMessage(), this.resourceBundle.getString("error.on_initialization"), false, 2);
                this.log.logError(this.resourceBundle.getString("error.on_initialization"), (Throwable)e);
            }
        }
        catch (XulException e) {
            this.log.logError(this.resourceBundle.getString("error.on_initialization"), (Throwable)e);
        }
    }

    public void show() {
        this.controller.open();
    }

    public void addProviders(List<NamedProvider> providers) {
        this.controller.addProviders(providers);
    }

    public BindingFactory getBindingFactory() {
        return this.controller.getBindingFactory();
    }
}

