/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.auth.model;

import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.ui.core.auth.model.AuthProvider;
import org.pentaho.di.ui.core.auth.model.NamedModelObject;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class NamedProvider
extends XulEventSourceAdapter
implements NamedModelObject<AuthProvider> {
    String name = null;
    AuthProvider provider = null;

    public NamedProvider(String name, AuthProvider provider) {
        this.name = name;
        this.provider = provider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String prev = this.name;
        this.name = name;
        this.firePropertyChange("name", prev, this.name);
    }

    @Override
    public void setItem(AuthProvider object) {
        this.provider = object;
        try {
            this.provider.fireBindingsChanged();
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Binding event error while attempting to select provider.", (Throwable)e);
        }
    }

    @Override
    public AuthProvider getItem() {
        return this.provider;
    }

    public String toString() {
        return this.name;
    }
}

