/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.ui.core.database.dialog.GetPreviewTableProgressDialog;
import org.pentaho.di.ui.core.database.dialog.XulStepFieldsController;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.components.XulTreeCol;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeCols;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.swt.tags.SwtTreeCell;
import org.pentaho.ui.xul.swt.tags.SwtTreeCol;
import org.pentaho.ui.xul.swt.tags.SwtTreeCols;

public class XulPreviewRowsController
extends AbstractXulEventHandler {
    private Shell shell;
    private DatabaseMeta databaseMeta;
    private String schema;
    private String table;
    private int limit;
    private BindingFactory bf;
    private Binding rowCountBinding;
    private String rowCount;
    private static Log logger = LogFactory.getLog(XulStepFieldsController.class);

    public XulPreviewRowsController(Shell aShell, DatabaseMeta aDatabaseMeta, String aSchema, String aTable, int aLimit) {
        this.shell = aShell;
        this.databaseMeta = aDatabaseMeta;
        this.schema = aSchema;
        this.table = aTable;
        this.limit = aLimit;
        this.bf = new DefaultBindingFactory();
    }

    public void init() {
        this.createPreviewRows();
        this.bf.setDocument(this.document);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.rowCountBinding = this.bf.createBinding((Object)this, "rowCount", "rowCountLabel", "value", new BindingConvertor[0]);
        this.fireBindings();
    }

    private void fireBindings() {
        try {
            this.rowCountBinding.fireSourceChanged();
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    private void createPreviewRows() {
        GetPreviewTableProgressDialog theProgressDialog = new GetPreviewTableProgressDialog(this.shell, this.databaseMeta, this.schema, this.table, this.limit);
        List<Object[]> thePreviewData = theProgressDialog.open();
        Object[] theObj2 = null;
        XulTreeRow theRow = null;
        Object theValue = null;
        SwtTreeCell theCell = null;
        int theRowCount = 0;
        XulTree thePreviewTable = (XulTree)this.document.getElementById("table_data");
        thePreviewTable.getRootChildren().removeAll();
        for (Object[] theObj2 : thePreviewData) {
            theRow = thePreviewTable.getRootChildren().addNewRow();
            ++theRowCount;
            for (int i = 0; i < theObj2.length; ++i) {
                theValue = theObj2[i];
                theCell = new SwtTreeCell(null);
                theCell.setLabel(theValue == null ? "" : theValue.toString());
                theRow.addCell((XulTreeCell)theCell);
            }
        }
        SwtTreeCol theColumn = null;
        String[] theFieldNames = theProgressDialog.getRowMeta().getFieldNames();
        SwtTreeCols theColumns = new SwtTreeCols(null, (XulComponent)thePreviewTable, null, null);
        for (int i = 0; i < theFieldNames.length; ++i) {
            theColumn = new SwtTreeCol(null, null, null, null);
            theColumn.setWidth(100);
            theColumn.setLabel(theFieldNames[i]);
            theColumns.addColumn((XulTreeCol)theColumn);
        }
        thePreviewTable.setColumns((XulTreeCols)theColumns);
        thePreviewTable.update();
        this.setRowCount("Rows of step: " + this.table + " (" + theRowCount + " rows)");
    }

    public void accept() {
        XulDialog theDialog = (XulDialog)this.document.getElementById("previewRowsDialog");
        theDialog.setVisible(false);
    }

    public void setRowCount(String aRowCount) {
        this.rowCount = aRowCount;
    }

    public String getRowCount() {
        return this.rowCount;
    }

    public String getName() {
        return "previewRows";
    }
}

