/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.awt.Desktop;
import java.net.URI;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.WindowProperty;

public class BrowserEnvironmentWarningDialog
extends Dialog {
    private static Class<?> PKG = BrowserEnvironmentWarningDialog.class;
    private Shell shell;
    private PropsUI props;
    private Label warningIcon;
    private Text description;
    private Link link;
    private Button closeButton;
    private final int margin = 15;
    private final int padding = 30;
    private final int MAX_TEXT_WIDTH_UBUNTU = 418;
    private final int MAX_TEXT_WIDTH_WINDOWS = 286;
    private final int MAX_TEXT_WIDTH_MAC = 326;
    private final LogChannelInterface log = new LogChannel((Object)this);
    private static final String URI_PATH = "/0D0/160/000";

    public BrowserEnvironmentWarningDialog(Shell parent) {
        super(parent, 0);
    }

    public void showWarningDialog(EnvironmentCase environment) {
        switch (environment) {
            case UBUNTU: {
                this.showUbuntuWarningDialog();
                break;
            }
            case UBUNTU_THIN: {
                this.showUbuntuThinWarningDialog();
                break;
            }
            case MAC_OS_X: {
                this.showMacWarningDialog();
                break;
            }
            case MAC_OS_X_THIN: {
                this.showMacThinWarningDialog();
                break;
            }
            case WINDOWS: {
                this.showWindowsWarningDialog();
                break;
            }
            case WINDOWS_THIN: {
                this.showWindowsThinWarningDialog();
                break;
            }
            default: {
                this.log.logBasic("Unknown Environment");
            }
        }
    }

    private void showMacWarningDialog() {
        this.showWarningDialog(BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Message.Mac", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.HelpLink", (String[])new String[0]), EnvironmentCase.MAC_OS_X, 326);
    }

    private void showUbuntuWarningDialog() {
        this.showWarningDialog(BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Title.Ubuntu", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Message.Ubuntu", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.HelpLink.Ubuntu", (String[])new String[0]), EnvironmentCase.UBUNTU, 418);
    }

    private void showWindowsWarningDialog() {
        this.showWarningDialog(BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Message.Windows", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.HelpLink", (String[])new String[0]), EnvironmentCase.WINDOWS, 286);
    }

    private void showMacThinWarningDialog() {
        this.showWarningDialog(BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Message.Mac.Thin", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.HelpLink", (String[])new String[0]), EnvironmentCase.MAC_OS_X_THIN, 326);
    }

    private void showUbuntuThinWarningDialog() {
        this.showWarningDialog(BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Title.Ubuntu", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Message.Ubuntu.Thin", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.HelpLink.Ubuntu", (String[])new String[0]), EnvironmentCase.UBUNTU_THIN, 418);
    }

    private void showWindowsThinWarningDialog() {
        this.showWarningDialog(BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.Message.Windows.Thin", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BrowserEnvironmentWarningDialog.HelpLink", (String[])new String[0]), EnvironmentCase.WINDOWS_THIN, 286);
    }

    private void showWarningDialog(String title, String message, String helpLink, EnvironmentCase environment, int maxTextWidth) {
        if (this.getParent().isDisposed()) {
            return;
        }
        this.props = PropsUI.getInstance();
        Display display = this.getParent().getDisplay();
        this.shell = new Shell(this.getParent(), 65568);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(title);
        this.setWarningIcon(display);
        this.setWarningText(message, maxTextWidth);
        this.setHelpLink(display, helpLink, maxTextWidth, environment);
        this.setCloseButton();
        this.shell.setSize(this.shell.computeSize(-1, -1, true));
        Rectangle screenSize = display.getPrimaryMonitor().getBounds();
        this.shell.setLocation((screenSize.width - this.shell.getBounds().width) / 2, (screenSize.height - this.shell.getBounds().height) / 2);
        this.closeButton.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void setWarningIcon(Display display) {
        this.warningIcon = new Label((Composite)this.shell, 0);
        Image image = display.getSystemImage(8);
        this.warningIcon.setImage(image);
        this.props.setLook((Control)this.warningIcon);
        FormData fdIcon = new FormData();
        fdIcon.left = new FormAttachment(0, 0);
        fdIcon.top = new FormAttachment(0, 0);
        fdIcon.right = new FormAttachment(0, image.getBounds().width);
        fdIcon.bottom = new FormAttachment(0, image.getBounds().height);
        this.warningIcon.setLayoutData((Object)fdIcon);
    }

    private void setWarningText(String message, int maxTextWidth) {
        this.description = new Text((Composite)this.shell, 573506);
        this.description.setText(message);
        this.description.setEditable(false);
        FormData fdlDesc = new FormData();
        fdlDesc.left = new FormAttachment((Control)this.warningIcon, 15);
        fdlDesc.top = new FormAttachment(0, 0);
        fdlDesc.width = maxTextWidth;
        this.description.setLayoutData((Object)fdlDesc);
        this.props.setLook((Control)this.description);
    }

    private void setHelpLink(Display display, String helpLink, int maxTextWidth, EnvironmentCase environment) {
        this.link = new Link((Composite)this.shell, 68);
        this.link.setText(helpLink);
        if (environment == EnvironmentCase.MAC_OS_X || environment == EnvironmentCase.MAC_OS_X_THIN) {
            FontData[] fD = this.link.getFont().getFontData();
            fD[0].setHeight(13);
            this.link.setFont(new Font((Device)display, fD[0]));
        }
        FormData fdlink = new FormData();
        fdlink.left = new FormAttachment((Control)this.warningIcon, 15);
        fdlink.top = new FormAttachment((Control)this.description, 15);
        fdlink.width = maxTextWidth;
        this.link.setLayoutData((Object)fdlink);
        this.props.setLook((Control)this.link);
        this.link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI(Const.getDocUrl((String)BrowserEnvironmentWarningDialog.URI_PATH)));
                    }
                    catch (Exception e) {
                        BrowserEnvironmentWarningDialog.this.log.logError("Error opening external browser", (Throwable)e);
                    }
                }
            }
        });
    }

    private void setCloseButton() {
        this.closeButton = new Button((Composite)this.shell, 8);
        this.closeButton.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        FormData fdbutton = new FormData();
        fdbutton.right = new FormAttachment(100, 0);
        fdbutton.top = new FormAttachment((Control)this.link, 30);
        fdbutton.height = 30;
        this.closeButton.setLayoutData((Object)fdbutton);
        this.props.setLook((Control)this.closeButton);
        this.closeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BrowserEnvironmentWarningDialog.this.close();
            }
        });
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void close() {
        this.dispose();
    }

    public static enum EnvironmentCase {
        UBUNTU,
        UBUNTU_THIN,
        MAC_OS_X,
        MAC_OS_X_THIN,
        WINDOWS,
        WINDOWS_THIN;

    }
}

