/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class EnterSearchDialog {
    private static Class<?> PKG = DatabaseDialog.class;
    private static final PropsUI props = PropsUI.getInstance();
    private Shell parentShell;
    private Shell shell;
    private boolean retval;
    private Display display;
    private boolean searchingSteps;
    private boolean searchingDatabases;
    private boolean searchingNotes;
    private String filterString;
    private Label wlStep;
    private Button wStep;
    private Label wlDB;
    private Button wDB;
    private Label wlNote;
    private Button wNote;
    private Label wlFilter;
    private Text wFilter;

    public EnterSearchDialog(Shell parentShell) {
        this.parentShell = parentShell;
        this.display = parentShell.getDisplay();
        this.retval = true;
        this.searchingSteps = true;
        this.searchingDatabases = true;
        this.searchingNotes = true;
    }

    public boolean open() {
        this.shell = new Shell(this.parentShell, 3312);
        props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Shell.Title", (String[])new String[0]));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        int middle = props.getMiddlePct();
        int margin = 4;
        this.wlStep = new Label((Composite)this.shell, 131072);
        this.wlStep.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Step.Label", (String[])new String[0]));
        props.setLook((Control)this.wlStep);
        FormData fdlStep = new FormData();
        fdlStep.left = new FormAttachment(0, 0);
        fdlStep.top = new FormAttachment(0, 0);
        fdlStep.right = new FormAttachment(middle, -margin);
        this.wlStep.setLayoutData((Object)fdlStep);
        this.wStep = new Button((Composite)this.shell, 32);
        props.setLook((Control)this.wStep);
        this.wStep.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Step.Tooltip", (String[])new String[0]));
        FormData fdStep = new FormData();
        fdStep.left = new FormAttachment(middle, 0);
        fdStep.top = new FormAttachment(0, 0);
        fdStep.right = new FormAttachment(100, 0);
        this.wStep.setLayoutData((Object)fdStep);
        this.wlDB = new Label((Composite)this.shell, 131072);
        this.wlDB.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.DB.Label", (String[])new String[0]));
        props.setLook((Control)this.wlDB);
        FormData fdlDB = new FormData();
        fdlDB.left = new FormAttachment(0, 0);
        fdlDB.top = new FormAttachment((Control)this.wStep, margin);
        fdlDB.right = new FormAttachment(middle, -margin);
        this.wlDB.setLayoutData((Object)fdlDB);
        this.wDB = new Button((Composite)this.shell, 32);
        props.setLook((Control)this.wDB);
        this.wDB.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.DB.Tooltip", (String[])new String[0]));
        FormData fdDB = new FormData();
        fdDB.left = new FormAttachment(middle, 0);
        fdDB.top = new FormAttachment((Control)this.wStep, margin);
        fdDB.right = new FormAttachment(100, 0);
        this.wDB.setLayoutData((Object)fdDB);
        this.wlNote = new Label((Composite)this.shell, 131072);
        this.wlNote.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Note.Label", (String[])new String[0]));
        props.setLook((Control)this.wlNote);
        FormData fdlNote = new FormData();
        fdlNote.left = new FormAttachment(0, 0);
        fdlNote.top = new FormAttachment((Control)this.wDB, margin);
        fdlNote.right = new FormAttachment(middle, -margin);
        this.wlNote.setLayoutData((Object)fdlNote);
        this.wNote = new Button((Composite)this.shell, 32);
        props.setLook((Control)this.wNote);
        this.wNote.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Note.Tooltip", (String[])new String[0]));
        FormData fdNote = new FormData();
        fdNote.left = new FormAttachment(middle, 0);
        fdNote.top = new FormAttachment((Control)this.wDB, margin);
        fdNote.right = new FormAttachment(100, 0);
        this.wNote.setLayoutData((Object)fdNote);
        this.wlFilter = new Label((Composite)this.shell, 131072);
        this.wlFilter.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.FilterSelection.Label", (String[])new String[0]));
        props.setLook((Control)this.wlFilter);
        FormData fdlFilter = new FormData();
        fdlFilter.left = new FormAttachment(0, 0);
        fdlFilter.right = new FormAttachment(middle, -margin);
        fdlFilter.top = new FormAttachment((Control)this.wNote, 3 * margin);
        this.wlFilter.setLayoutData((Object)fdlFilter);
        this.wFilter = new Text((Composite)this.shell, 2052);
        props.setLook((Control)this.wFilter);
        FormData fdFilter = new FormData();
        fdFilter.left = new FormAttachment(middle, 0);
        fdFilter.top = new FormAttachment((Control)this.wNote, 3 * margin);
        fdFilter.right = new FormAttachment(100, 0);
        this.wFilter.setLayoutData((Object)fdFilter);
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSearchDialog.this.ok();
            }
        });
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSearchDialog.this.cancel();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOK, wCancel}, 4, (Control)this.wFilter);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterSearchDialog.this.cancel();
            }
        });
        SelectionAdapter lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterSearchDialog.this.ok();
            }
        };
        this.wFilter.addSelectionListener((SelectionListener)lsDef);
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.retval;
    }

    private void getData() {
        this.wStep.setSelection(this.searchingSteps);
        this.wDB.setSelection(this.searchingDatabases);
        this.wNote.setSelection(this.searchingNotes);
        this.wFilter.setText(Const.NVL((String)this.filterString, (String)""));
        this.wFilter.setFocus();
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        props.setScreen(winprop);
        this.shell.dispose();
    }

    public void cancel() {
        this.retval = false;
        this.dispose();
    }

    public void ok() {
        this.retval = true;
        this.searchingSteps = this.wStep.getSelection();
        this.searchingDatabases = this.wDB.getSelection();
        this.searchingNotes = this.wNote.getSelection();
        this.filterString = this.wFilter.getText();
        this.dispose();
    }

    public boolean isSearchingSteps() {
        return this.searchingSteps;
    }

    public boolean isSearchingDatabases() {
        return this.searchingDatabases;
    }

    public boolean isSearchingNotes() {
        return this.searchingNotes;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }
}

