/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.GetCaretPositionInterface;
import org.pentaho.di.ui.core.widget.InsertTextInterface;
import org.pentaho.di.ui.core.widget.StyledTextComp;

public class ControlSpaceKeyAdapter
extends KeyAdapter {
    private static Class<?> PKG = ControlSpaceKeyAdapter.class;
    private static final PropsUI props = PropsUI.getInstance();
    private GetCaretPositionInterface getCaretPositionInterface;
    private InsertTextInterface insertTextInterface;
    private VariableSpace variables;
    private Control control;

    public ControlSpaceKeyAdapter(VariableSpace space, Control control) {
        this(space, control, null, null);
    }

    public ControlSpaceKeyAdapter(VariableSpace space, Control control, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        this.variables = space;
        this.control = control;
        this.getCaretPositionInterface = getCaretPositionInterface;
        this.insertTextInterface = insertTextInterface;
    }

    private boolean isHotKey(KeyEvent e) {
        if (System.getProperty("user.language").equals("zh")) {
            return e.character == ' ' && (e.stateMask & 0x40000) != 0 && (e.stateMask & 0x10000) != 0;
        }
        if (System.getProperty("os.name").startsWith("Mac OS X")) {
            return e.character == ' ' && (e.stateMask & SWT.MOD1) != 0 && (e.stateMask & 0x10000) == 0;
        }
        return e.character == ' ' && (e.stateMask & 0x40000) != 0 && (e.stateMask & 0x10000) == 0;
    }

    public void keyPressed(KeyEvent e) {
        if (this.isHotKey(e)) {
            e.doit = false;
            this.control.setData((Object)Boolean.TRUE);
            final int position = this.getCaretPositionInterface != null ? this.getCaretPositionInterface.getCaretPosition() : -1;
            Rectangle bounds = this.control.getBounds();
            Point location = GUIResource.calculateControlPosition(this.control);
            final Shell shell = new Shell(this.control.getShell(), 0);
            shell.setSize(bounds.width > 300 ? bounds.width : 300, 200);
            shell.setLocation(location.x, location.y + bounds.height);
            shell.setLayout((Layout)new FillLayout());
            final List list = new List((Composite)shell, 772);
            props.setLook((Control)list);
            list.setItems(ControlSpaceKeyAdapter.getVariableNames(this.variables));
            final DefaultToolTip toolTip = new DefaultToolTip((Control)list, 1, true);
            toolTip.setImage(GUIResource.getInstance().getImageVariable());
            toolTip.setHideOnMouseDown(true);
            toolTip.setRespectMonitorBounds(true);
            toolTip.setRespectDisplayBounds(true);
            toolTip.setPopupDelay(350);
            list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public synchronized void widgetDefaultSelected(SelectionEvent e) {
                    ControlSpaceKeyAdapter.applyChanges(shell, list, ControlSpaceKeyAdapter.this.control, position, ControlSpaceKeyAdapter.this.insertTextInterface);
                }

                public void widgetSelected(SelectionEvent event) {
                    if (list.getSelectionCount() <= 0) {
                        return;
                    }
                    String name = list.getSelection()[0];
                    String value = ControlSpaceKeyAdapter.this.variables.getVariable(name);
                    Rectangle shellBounds = shell.getBounds();
                    String message = BaseMessages.getString((Class)PKG, (String)"TextVar.VariableValue.Message", (String[])new String[]{name, value});
                    if (name.startsWith("Internal")) {
                        message = message + BaseMessages.getString((Class)PKG, (String)"TextVar.InternalVariable.Message", (String[])new String[0]);
                    }
                    toolTip.setText(message);
                    toolTip.hide();
                    toolTip.show(new Point(shellBounds.width, 0));
                }
            });
            list.addKeyListener((KeyListener)new KeyAdapter(){

                public synchronized void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13 && (e.keyCode & 0x40000) == 0 && (e.keyCode & 0x20000) == 0) {
                        ControlSpaceKeyAdapter.applyChanges(shell, list, ControlSpaceKeyAdapter.this.control, position, ControlSpaceKeyAdapter.this.insertTextInterface);
                    }
                }
            });
            list.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    shell.dispose();
                    if (!ControlSpaceKeyAdapter.this.control.isDisposed()) {
                        ControlSpaceKeyAdapter.this.control.setData((Object)Boolean.FALSE);
                    }
                }
            });
            shell.open();
        }
    }

    private static final void applyChanges(Shell shell, List list, Control control, int position, InsertTextInterface insertTextInterface) {
        String selection = list.getSelection()[0].contains(Const.getDeprecatedPrefix()) ? list.getSelection()[0].replace(Const.getDeprecatedPrefix(), "") : list.getSelection()[0];
        String extra = "${" + selection + "}";
        if (insertTextInterface != null) {
            insertTextInterface.insertText(extra, position);
        } else {
            if (control.isDisposed()) {
                return;
            }
            if (list.getSelectionCount() <= 0) {
                return;
            }
            if (control instanceof Text) {
                ((Text)control).insert(extra);
            } else if (control instanceof CCombo) {
                CCombo combo = (CCombo)control;
                combo.setText(extra);
            } else if (control instanceof StyledTextComp) {
                ((StyledTextComp)control).insert(extra);
            } else if (control instanceof StyledText) {
                ((StyledText)control).insert(extra);
            }
        }
        if (!shell.isDisposed()) {
            shell.dispose();
        }
        if (!control.isDisposed()) {
            control.setData((Object)Boolean.FALSE);
        }
    }

    public static final String[] getVariableNames(VariableSpace space) {
        String[] variableNames = space.listVariables();
        block0: for (int i = 0; i < variableNames.length; ++i) {
            for (int j = 0; j < Const.DEPRECATED_VARIABLES.length; ++j) {
                if (!variableNames[i].equals(Const.DEPRECATED_VARIABLES[j])) continue;
                variableNames[i] = variableNames[i] + Const.getDeprecatedPrefix();
                continue block0;
            }
        }
        Arrays.sort(variableNames, new Comparator<String>(){

            @Override
            public int compare(String var1, String var2) {
                if (var1.endsWith(Const.getDeprecatedPrefix()) && var2.endsWith(Const.getDeprecatedPrefix())) {
                    return 0;
                }
                if (var1.endsWith(Const.getDeprecatedPrefix()) && !var2.endsWith(Const.getDeprecatedPrefix())) {
                    return 1;
                }
                if (!var1.endsWith(Const.getDeprecatedPrefix()) && var2.endsWith(Const.getDeprecatedPrefix())) {
                    return -1;
                }
                return var1.compareTo(var2);
            }
        });
        return variableNames;
    }

    public void setVariables(VariableSpace vars) {
        this.variables = vars;
    }
}

