/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entry;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.pentaho.di.i18n.PackageMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.WidgetUtils;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public abstract class JobStepDialog<T extends JobEntryInterface>
extends JobEntryDialog
implements JobEntryDialogInterface {
    protected static final int LARGE_MARGIN = 15;
    protected static final int FIELD_WIDTH = 60;
    protected static final int BUTTON_WIDTH = 80;
    protected PackageMessages messages;
    protected PackageMessages systemMessages = new PackageMessages(((Object)((Object)this)).getClass(), "System.");
    protected Button wCancel;
    protected Button wOK;
    private boolean bigIcon;
    private final T entry;
    private final TypedListener DEFAULT_FINISH_EVENT = new TypedListener((SWTEventListener)new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent e) {
            JobStepDialog.this.ok();
        }
    });
    private final TypedListener CHANGE_MODIFY_LISTENER = new TypedListener((SWTEventListener)new ModifyListener(){

        public void modifyText(ModifyEvent paramModifyEvent) {
            JobStepDialog.this.dialogModified();
        }
    });
    private final TypedListener CHANGE_SELECT_LISTENER = new TypedListener((SWTEventListener)new SelectionAdapter(){

        public void widgetSelected(SelectionEvent paramSelectionEvent) {
            JobStepDialog.this.dialogModified();
        }
    });

    private void dialogModified() {
        this.entry.setChanged();
    }

    public JobStepDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta, boolean bigIcon) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.entry = jobEntryInt;
        this.bigIcon = bigIcon;
        this.initMessages();
        if (this.entry.getName() == null) {
            this.entry.setName(this.messages.getString("Title", new String[0]));
        }
    }

    protected void initMessages() {
        this.messages = new PackageMessages(((Object)((Object)this)).getClass());
    }

    public T getEntry() {
        return this.entry;
    }

    public JobEntryInterface open() {
        this.shell = new Shell(this.getParent(), this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        WidgetUtils.setFormLayout((Composite)this.shell, 15);
        JobDialog.setShellImage(this.shell, this.entry);
        this.shell.setText(this.messages.getString("Title", new String[0]));
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobStepDialog.this.cancel();
            }
        });
        if (this.bigIcon) {
            Label lIcon = new Label((Composite)this.shell, 131072);
            lIcon.setLayoutData((Object)new FormDataBuilder().right().result());
            lIcon.setImage(JobDialog.getImage(this.shell, JobDialog.getPlugin(this.getEntry())));
        }
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(this.systemMessages.getString("Button.Cancel", new String[0]));
        this.wCancel.setLayoutData((Object)new FormDataBuilder().bottom().right().width(80).result());
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(this.systemMessages.getString("Button.OK", new String[0]));
        this.wOK.setLayoutData((Object)new FormDataBuilder().bottom().right((Control)this.wCancel, -5).width(80).result());
        this.doOpen();
        this.getData();
        this.handleChilds((Composite)this.shell);
        BaseStepDialog.setSize(this.shell);
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JobStepDialog.this.cancel();
            }
        });
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JobStepDialog.this.ok();
            }
        });
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.getEntry();
    }

    private void handleChilds(Composite composite) {
        for (Control el : composite.getChildren()) {
            this.handleElement(el);
            if (!(el instanceof Composite)) continue;
            this.handleChilds((Composite)el);
        }
    }

    protected void handleElement(Control el) {
        this.handleElement(el, 0);
    }

    protected void handleElement(Control el, int style) {
        this.props.setLook(el, style);
        this.addDefaultFinishEvent(el);
        this.addModifyListener(el);
    }

    private void addModifyListener(Control el) {
        if (el instanceof Text) {
            this.addListener(el, 24, this.CHANGE_MODIFY_LISTENER);
        }
        if (el instanceof Button) {
            this.addListener(el, 13, this.CHANGE_SELECT_LISTENER);
        }
    }

    private void addDefaultFinishEvent(Control el) {
        this.addListener(el, 14, this.DEFAULT_FINISH_EVENT);
    }

    private void addListener(Control el, int event, TypedListener listener) {
        if (ArrayUtils.contains((Object[])el.getListeners(event), (Object)listener)) {
            return;
        }
        el.addListener(event, (Listener)listener);
    }

    private void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    protected void ok() {
        if (this.entry.hasChanged()) {
            this.doOk();
        }
        this.dispose();
    }

    protected void cancel() {
        this.entry.setChanged(false);
        this.dispose();
    }

    protected abstract void getData();

    protected abstract void doOk();

    protected abstract void doOpen();
}

