/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.kdr;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterPasswordDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;
import org.pentaho.di.ui.repository.dialog.UpgradeRepositoryProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class KettleDatabaseRepositoryDialog
implements RepositoryDialogInterface {
    private static Class<?> PKG = RepositoryDialogInterface.class;
    private RepositoryDialogInterface.MODE mode;
    private Label wlConnection;
    private Button wnConnection;
    private Button weConnection;
    private Button wdConnection;
    private CCombo wConnection;
    private FormData fdlConnection;
    private FormData fdConnection;
    private FormData fdnConnection;
    private FormData fdeConnection;
    private FormData fddConnection;
    private Label wlId;
    private Text wId;
    private FormData fldId;
    private FormData fdId;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Button wOK;
    private Button wCreate;
    private Button wDrop;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCreate;
    private Listener lsDrop;
    private Listener lsCancel;
    private Display display;
    private Shell shell;
    private PropsUI props;
    private KettleDatabaseRepositoryMeta input;
    private RepositoriesMeta repositories;
    private RepositoriesMeta masterRepositoriesMeta;
    private String masterRepositoryName;
    private DatabaseDialog databaseDialog;

    public KettleDatabaseRepositoryDialog(Shell parent, int style, RepositoryMeta repositoryMeta, RepositoriesMeta repositoriesMeta) {
        this.display = parent.getDisplay();
        this.props = PropsUI.getInstance();
        this.input = (KettleDatabaseRepositoryMeta)repositoryMeta;
        this.repositories = repositoriesMeta;
        this.masterRepositoriesMeta = repositoriesMeta.clone();
        this.masterRepositoryName = repositoryMeta.getName();
        this.shell = new Shell(parent, style | 0x860 | 0x10 | 0x400 | 0x80 | 0x10000 | 0x10000000);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Main.Title", (String[])new String[0]));
    }

    public KettleDatabaseRepositoryMeta open(RepositoryDialogInterface.MODE mode) {
        this.mode = mode;
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.shell.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Main.Title2", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wnConnection = new Button((Composite)this.shell, 8);
        this.wnConnection.setText(BaseMessages.getString(PKG, (String)"System.Button.New", (String[])new String[0]));
        this.weConnection = new Button((Composite)this.shell, 8);
        this.weConnection.setText(BaseMessages.getString(PKG, (String)"System.Button.Edit", (String[])new String[0]));
        this.wdConnection = new Button((Composite)this.shell, 8);
        this.wdConnection.setText(BaseMessages.getString(PKG, (String)"System.Button.Delete", (String[])new String[0]));
        this.fddConnection = new FormData();
        this.fddConnection.right = new FormAttachment(100, 0);
        this.fddConnection.top = new FormAttachment(0, margin);
        this.wdConnection.setLayoutData((Object)this.fddConnection);
        this.fdeConnection = new FormData();
        this.fdeConnection.right = new FormAttachment((Control)this.wdConnection, -margin);
        this.fdeConnection.top = new FormAttachment(0, margin);
        this.weConnection.setLayoutData((Object)this.fdeConnection);
        this.fdnConnection = new FormData();
        this.fdnConnection.right = new FormAttachment((Control)this.weConnection, -margin);
        this.fdnConnection.top = new FormAttachment(0, margin);
        this.wnConnection.setLayoutData((Object)this.fdnConnection);
        this.wConnection = new CCombo((Composite)this.shell, 2060);
        this.props.setLook((Control)this.wConnection);
        this.fdConnection = new FormData();
        this.fdConnection.left = new FormAttachment(middle, 0);
        this.fdConnection.top = new FormAttachment((Control)this.wnConnection, 0, 0x1000000);
        this.fdConnection.right = new FormAttachment((Control)this.wnConnection, -margin);
        this.wConnection.setLayoutData((Object)this.fdConnection);
        this.fillConnections();
        this.wlConnection = new Label((Composite)this.shell, 131072);
        this.wlConnection.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Label.SelectConnection", (String[])new String[0]));
        this.props.setLook((Control)this.wlConnection);
        this.fdlConnection = new FormData();
        this.fdlConnection.left = new FormAttachment(0, 0);
        this.fdlConnection.right = new FormAttachment(middle, -margin);
        this.fdlConnection.top = new FormAttachment((Control)this.wnConnection, 0, 0x1000000);
        this.wlConnection.setLayoutData((Object)this.fdlConnection);
        this.wnConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DatabaseMeta databaseMeta = new DatabaseMeta();
                KettleDatabaseRepositoryDialog.this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
                if (KettleDatabaseRepositoryDialog.this.getDatabaseDialog().open() != null) {
                    KettleDatabaseRepositoryDialog.this.repositories.addDatabase(KettleDatabaseRepositoryDialog.this.getDatabaseDialog().getDatabaseMeta());
                    KettleDatabaseRepositoryDialog.this.fillConnections();
                    int idx = KettleDatabaseRepositoryDialog.this.repositories.indexOfDatabase(KettleDatabaseRepositoryDialog.this.getDatabaseDialog().getDatabaseMeta());
                    KettleDatabaseRepositoryDialog.this.wConnection.select(idx);
                }
            }
        });
        this.weConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DatabaseMeta databaseMeta = KettleDatabaseRepositoryDialog.this.repositories.searchDatabase(KettleDatabaseRepositoryDialog.this.wConnection.getText());
                if (databaseMeta != null) {
                    KettleDatabaseRepositoryDialog.this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
                    if (KettleDatabaseRepositoryDialog.this.getDatabaseDialog().open() != null) {
                        KettleDatabaseRepositoryDialog.this.fillConnections();
                        int idx = KettleDatabaseRepositoryDialog.this.repositories.indexOfDatabase(KettleDatabaseRepositoryDialog.this.getDatabaseDialog().getDatabaseMeta());
                        KettleDatabaseRepositoryDialog.this.wConnection.select(idx);
                    }
                }
            }
        });
        this.wdConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DatabaseMeta dbinfo = KettleDatabaseRepositoryDialog.this.repositories.searchDatabase(KettleDatabaseRepositoryDialog.this.wConnection.getText());
                if (dbinfo != null) {
                    int idx = KettleDatabaseRepositoryDialog.this.repositories.indexOfDatabase(dbinfo);
                    KettleDatabaseRepositoryDialog.this.repositories.removeDatabase(idx);
                    KettleDatabaseRepositoryDialog.this.fillConnections();
                }
            }
        });
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Label.Name", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.top = new FormAttachment((Control)this.wnConnection, margin * 2);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment((Control)this.wnConnection, margin * 2);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wlId = new Label((Composite)this.shell, 131072);
        this.wlId.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Label.Description", (String[])new String[0]));
        this.props.setLook((Control)this.wlId);
        this.fldId = new FormData();
        this.fldId.left = new FormAttachment(0, 0);
        this.fldId.top = new FormAttachment((Control)this.wlName, margin * 3);
        this.fldId.right = new FormAttachment(middle, -margin);
        this.wlId.setLayoutData((Object)this.fldId);
        this.wId = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wId);
        this.fdId = new FormData();
        this.fdId.left = new FormAttachment(middle, 0);
        this.fdId.top = new FormAttachment((Control)this.wlName, margin * 3);
        this.fdId.right = new FormAttachment(100, 0);
        this.wId.setLayoutData((Object)this.fdId);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                KettleDatabaseRepositoryDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Button.CreateOrUpgrade", (String[])new String[0]));
        this.lsCreate = new Listener(){

            public void handleEvent(Event e) {
                KettleDatabaseRepositoryDialog.this.create();
            }
        };
        this.wCreate.addListener(13, this.lsCreate);
        this.wDrop = new Button((Composite)this.shell, 8);
        this.wDrop.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Button.Remove", (String[])new String[0]));
        this.lsDrop = new Listener(){

            public void handleEvent(Event e) {
                KettleDatabaseRepositoryDialog.this.drop();
            }
        };
        this.wDrop.addListener(13, this.lsDrop);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                KettleDatabaseRepositoryDialog.this.cancel();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCreate, this.wDrop, this.wCancel}, margin, (Control)this.wlId);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                KettleDatabaseRepositoryDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.input;
    }

    private DatabaseDialog getDatabaseDialog() {
        if (this.databaseDialog != null) {
            return this.databaseDialog;
        }
        this.databaseDialog = new DatabaseDialog(this.shell);
        return this.databaseDialog;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.input.getName() != null) {
            this.wName.setText(this.input.getName());
        }
        if (this.input.getDescription() != null) {
            this.wId.setText(this.input.getDescription());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection().getName());
        }
    }

    private void cancel() {
        this.input = null;
        this.dispose();
    }

    private void getInfo(KettleDatabaseRepositoryMeta info) {
        info.setName(this.wName.getText());
        info.setDescription(this.wId.getText());
        int idx = this.wConnection.getSelectionIndex();
        if (idx >= 0) {
            DatabaseMeta dbinfo = this.repositories.getDatabase(idx);
            info.setConnection(dbinfo);
        } else {
            info.setConnection(null);
        }
    }

    private void ok() {
        this.getInfo(this.input);
        if (this.input.getConnection() != null) {
            if (this.input.getName() != null && this.input.getName().length() > 0) {
                if (this.input.getDescription() != null && this.input.getDescription().length() > 0) {
                    if (this.mode == RepositoryDialogInterface.MODE.ADD) {
                        if (this.masterRepositoriesMeta.searchRepository(this.input.getName()) == null) {
                            this.dispose();
                        } else {
                            this.displayRepositoryAlreadyExistMessage(this.input.getName());
                        }
                    } else if (this.masterRepositoryName.equals(this.input.getName())) {
                        this.dispose();
                    } else if (this.masterRepositoriesMeta.searchRepository(this.input.getName()) == null) {
                        this.dispose();
                    } else {
                        this.displayRepositoryAlreadyExistMessage(this.input.getName());
                    }
                } else {
                    MessageBox box = new MessageBox(this.shell, 33);
                    box.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.ErrorNoName.Message", (String[])new String[0]));
                    box.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Error.Title", (String[])new String[0]));
                    box.open();
                }
            } else {
                MessageBox box = new MessageBox(this.shell, 33);
                box.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.ErrorNoId.Message", (String[])new String[0]));
                box.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Error.Title", (String[])new String[0]));
                box.open();
            }
        } else {
            MessageBox box = new MessageBox(this.shell, 33);
            box.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.ErrorNoConnection.Message", (String[])new String[0]));
            box.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Error.Title", (String[])new String[0]));
            box.open();
        }
    }

    private void fillConnections() {
        this.wConnection.removeAll();
        for (int i = 0; i < this.repositories.nrDatabases(); ++i) {
            this.wConnection.add(this.repositories.getDatabase(i).getName());
        }
    }

    private void create() {
        System.out.println("Loading repository info...");
        KettleDatabaseRepositoryMeta repositoryMeta = new KettleDatabaseRepositoryMeta();
        this.getInfo(repositoryMeta);
        if (repositoryMeta.getConnection() != null) {
            if (repositoryMeta.getConnection().getAccessType() == 1) {
                System.out.println("Show ODBC warning...");
                MessageBox qmb = new MessageBox(this.shell, 200);
                qmb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.ODBCIsNotSafe.Message", (String[])new String[]{Const.CR, Const.CR}));
                qmb.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.ODBCIsNotSafe.Title", (String[])new String[0]));
                int answer = qmb.open();
                if (answer != 64) {
                    return;
                }
            }
            try {
                System.out.println("Allocating repository...");
                KettleDatabaseRepository rep = (KettleDatabaseRepository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
                rep.init((RepositoryMeta)repositoryMeta);
                if (!rep.getDatabaseMeta().getDatabaseInterface().supportsRepository()) {
                    System.out.println("Show database type is not supported warning...");
                    MessageBox qmb = new MessageBox(this.shell, 200);
                    qmb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.DBTypeNotSupport.Message", (String[])new String[]{Const.CR, Const.CR}));
                    qmb.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.DBTypeNotSupport.Title", (String[])new String[0]));
                    int answer = qmb.open();
                    if (answer != 64) {
                        return;
                    }
                }
                System.out.println("Connecting to database for repository creation...");
                rep.connectionDelegate.connect(true, true);
                boolean upgrade = false;
                String cu = BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.CreateUpgrade.Create", (String[])new String[0]);
                try {
                    String userTableName = rep.getDatabaseMeta().quoteField("R_USER");
                    upgrade = rep.getDatabase().checkTableExists(userTableName);
                    if (upgrade) {
                        cu = BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.CreateUpgrade.Upgrade", (String[])new String[0]);
                    }
                }
                catch (KettleDatabaseException dbe) {
                    rep.rollback();
                }
                MessageBox qmb = new MessageBox(this.shell, 200);
                qmb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.CreateUpgrade.Message1", (String[])new String[0]) + cu + BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.CreateUpgrade.Message2", (String[])new String[0]));
                qmb.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.CreateUpgrade.Title", (String[])new String[0]));
                int answer = qmb.open();
                if (answer == 64) {
                    boolean goAhead;
                    boolean bl = goAhead = !upgrade;
                    if (!goAhead) {
                        EnterPasswordDialog etd = new EnterPasswordDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.EnterPassword.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.EnterPassword.Message", (String[])new String[0]), "");
                        etd.setModal();
                        String pwd = etd.open();
                        if (pwd != null) {
                            try {
                                rep.disconnect();
                                rep.connect("admin", pwd, true);
                                goAhead = true;
                            }
                            catch (KettleException e) {
                                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UnableToVerifyUser.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UnableToVerifyUser.Message", (String[])new String[0]), (Exception)((Object)e));
                            }
                        }
                    }
                    if (goAhead) {
                        System.out.println(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.TryingToUpgradeRepository.Message1", (String[])new String[0]) + cu + BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.TryingToUpgradeRepository.Message2", (String[])new String[0]));
                        UpgradeRepositoryProgressDialog urpd = new UpgradeRepositoryProgressDialog(this.shell, rep, upgrade);
                        if (urpd.open()) {
                            if (urpd.isDryRun()) {
                                StringBuilder sql = new StringBuilder();
                                sql.append("-- Repository creation/upgrade DDL: ").append(Const.CR);
                                sql.append("--").append(Const.CR);
                                sql.append("-- Nothing was created nor modified in the target repository database.").append(Const.CR);
                                sql.append("-- Hit the OK button to execute the generated SQL or Close to reject the changes.").append(Const.CR);
                                sql.append("-- Please note that it is possible to change/edit the generated SQL before execution.").append(Const.CR);
                                sql.append("--").append(Const.CR);
                                for (String statement : urpd.getGeneratedStatements()) {
                                    if (statement.endsWith(";")) {
                                        sql.append(statement).append(Const.CR);
                                        continue;
                                    }
                                    sql.append(statement).append(";").append(Const.CR).append(Const.CR);
                                }
                                SQLEditor editor = new SQLEditor((VariableSpace)rep.getDatabaseMeta(), this.shell, 0, rep.getDatabaseMeta(), DBCache.getInstance(), sql.toString());
                                editor.open();
                            } else {
                                MessageBox mb = new MessageBox(this.shell, 34);
                                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UpgradeFinished.Message1", (String[])new String[0]) + cu + BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UpgradeFinished.Message2", (String[])new String[0]));
                                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UpgradeFinished.Title", (String[])new String[0]));
                                mb.open();
                            }
                        }
                    }
                }
                rep.disconnect();
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UnableToConnectToUpgrade.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UnableToConnectToUpgrade.Message", (String[])new String[0]) + Const.CR, (Exception)((Object)ke));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.FirstCreateAValidConnection.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.FirstCreateAValidConnection.Title", (String[])new String[0]));
            mb.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drop() {
        block9: {
            KettleDatabaseRepositoryMeta repositoryMeta = new KettleDatabaseRepositoryMeta();
            this.getInfo(repositoryMeta);
            try {
                EnterPasswordDialog etd;
                String pwd;
                KettleDatabaseRepository rep = (KettleDatabaseRepository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
                rep.init((RepositoryMeta)repositoryMeta);
                MessageBox qmb = new MessageBox(this.shell, 200);
                qmb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.ConfirmRemovalOfRepository.Message", (String[])new String[0]));
                qmb.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.ConfirmRemovalOfRepository.Title", (String[])new String[0]));
                int answer = qmb.open();
                if (answer != 64 || (pwd = (etd = new EnterPasswordDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.AskAdminPassword.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.AskAdminPassword.Message", (String[])new String[0]), "")).open()) == null) break block9;
                try {
                    rep.connect("admin", pwd);
                    try {
                        rep.dropRepositorySchema();
                        MessageBox mb = new MessageBox(this.shell, 34);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.RemovedRepositoryTables.Message", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.RemovedRepositoryTables.Title", (String[])new String[0]));
                        mb.open();
                    }
                    catch (KettleDatabaseException dbe) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UnableToRemoveRepository.Message", (String[])new String[0]) + Const.CR + dbe.getMessage());
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UnableToRemoveRepository.Title", (String[])new String[0]));
                        mb.open();
                    }
                }
                catch (KettleException e) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UnableToVerifyAdminUser.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.UnableToVerifyAdminUser.Message", (String[])new String[0]), (Exception)((Object)e));
                }
                finally {
                    rep.disconnect();
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.NoRepositoryFoundOnConnection.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.NoRepositoryFoundOnConnection.Message", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }

    private void displayRepositoryAlreadyExistMessage(String name) {
        MessageBox box = new MessageBox(this.shell, 33);
        box.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.ErrorIdExist.Message", (String[])new String[]{name}));
        box.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Error.Title", (String[])new String[0]));
        box.open();
    }
}

