/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.model;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.ui.repository.repositoryexplorer.model.IUIUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UISecurity;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class UISecurityUser
extends XulEventSourceAdapter {
    private UISecurity.Mode mode;
    private String name = null;
    private String description = null;
    private String password = null;
    protected RepositorySecurityManager rsm;

    public UISecurityUser(RepositorySecurityManager rsm) {
        this.rsm = rsm;
    }

    public void setUser(IUIUser user) throws Exception {
        this.setDescription(user.getDescription());
        this.setName(user.getName());
        this.setPassword("");
    }

    public UISecurityUser getUISecurityUser() {
        return this;
    }

    public UISecurity.Mode getMode() {
        return this.mode;
    }

    public void setMode(UISecurity.Mode mode) {
        this.mode = mode;
        this.firePropertyChange("mode", null, (Object)mode);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String previousValue = this.name;
        this.name = name;
        this.firePropertyChange("name", previousValue, name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String previousValue = this.description;
        this.description = description;
        this.firePropertyChange("description", previousValue, description);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        String previousValue = this.password;
        this.password = password;
        this.firePropertyChange("password", previousValue, password);
    }

    public void clear() {
        this.setMode(UISecurity.Mode.ADD);
        this.setName("");
        this.setDescription("");
        this.setPassword("");
    }

    public IUser getUserInfo() throws KettleException {
        IUser userInfo = this.rsm.constructUser();
        userInfo.setDescription(this.description);
        userInfo.setLogin(this.name);
        userInfo.setName(this.name);
        userInfo.setUsername(this.name);
        userInfo.setPassword(this.password);
        return userInfo;
    }
}

