/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.spoon.InstanceCreationException;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonClustersDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonDBDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegateRegistry;
import org.pentaho.di.ui.spoon.delegates.SpoonJobDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonPartitionsDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonSlaveDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonStepsDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonTabsDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonTransformationDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonTreeDelegate;

public class SpoonDelegates {
    public SpoonJobDelegate jobs;
    public SpoonTabsDelegate tabs;
    public SpoonTransformationDelegate trans;
    public SpoonSlaveDelegate slaves;
    public SpoonTreeDelegate tree;
    public SpoonStepsDelegate steps;
    public SpoonDBDelegate db;
    public SpoonClustersDelegate clusters;
    public SpoonPartitionsDelegate partitions;

    public SpoonDelegates(Spoon spoon) {
        this.tabs = new SpoonTabsDelegate(spoon);
        this.tree = new SpoonTreeDelegate(spoon);
        this.slaves = new SpoonSlaveDelegate(spoon);
        this.steps = new SpoonStepsDelegate(spoon);
        this.db = new SpoonDBDelegate(spoon);
        this.clusters = new SpoonClustersDelegate(spoon);
        this.partitions = new SpoonPartitionsDelegate(spoon);
        this.update(spoon);
    }

    public void update(Spoon spoon) {
        SpoonJobDelegate origJobs = this.jobs;
        try {
            this.jobs = (SpoonJobDelegate)SpoonDelegateRegistry.getInstance().constructSpoonJobDelegate(spoon);
        }
        catch (InstanceCreationException e) {
            this.jobs = new SpoonJobDelegate(spoon);
        }
        if (origJobs != null) {
            for (JobMeta jobMeta : origJobs.getLoadedJobs()) {
                this.jobs.addJob(jobMeta);
            }
        }
        SpoonTransformationDelegate origTrans = this.trans;
        try {
            this.trans = (SpoonTransformationDelegate)SpoonDelegateRegistry.getInstance().constructSpoonTransDelegate(spoon);
        }
        catch (InstanceCreationException e) {
            this.trans = new SpoonTransformationDelegate(spoon);
        }
        if (origTrans != null) {
            for (TransMeta transMeta : origTrans.getLoadedTransformations()) {
                this.trans.addTransformation(transMeta);
            }
        }
    }
}

