/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.util.ArrayList;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.dnd.DragAndDropContainer;
import org.pentaho.di.core.dnd.XMLTransfer;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TreeSelection;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonTreeDelegateExtension;

public class SpoonTreeDelegate
extends SpoonDelegate {
    public SpoonTreeDelegate(Spoon spoon) {
        super(spoon);
    }

    public TreeSelection[] getTreeObjects(Tree tree, Tree selectionTree, Tree coreObjectsTree) {
        TreeSelection object;
        String[] path;
        TreeItem treeItem;
        int s;
        TreeItem[] selection;
        ArrayList<TreeSelection> objects = new ArrayList<TreeSelection>();
        if (selectionTree != null && !selectionTree.isDisposed() && tree.equals(selectionTree)) {
            selection = selectionTree.getSelection();
            for (s = 0; s < selection.length; ++s) {
                treeItem = selection[s];
                path = ConstUI.getTreeStrings(treeItem);
                object = null;
                switch (path.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (path[0].equals(Spoon.STRING_TRANSFORMATIONS)) {
                            object = new TreeSelection(path[0], TransMeta.class);
                        }
                        if (!path[0].equals(Spoon.STRING_JOBS)) break;
                        object = new TreeSelection(path[0], JobMeta.class);
                        break;
                    }
                    case 2: {
                        if (path[0].equals(Spoon.STRING_BUILDING_BLOCKS) && path[1].equals(Spoon.STRING_TRANS_BASE)) {
                            object = new TreeSelection(path[1], PluginInterface.class);
                        }
                        if (path[0].equals(Spoon.STRING_TRANSFORMATIONS)) {
                            object = new TreeSelection(path[1], this.spoon.delegates.trans.getTransformation(path[1]));
                        }
                        if (!path[0].equals(Spoon.STRING_JOBS)) break;
                        object = new TreeSelection(path[1], this.spoon.delegates.jobs.getJob(path[1]));
                        break;
                    }
                    case 3: {
                        TransMeta transMeta;
                        if (path[0].equals(Spoon.STRING_TRANSFORMATIONS)) {
                            transMeta = this.spoon.delegates.trans.getTransformation(path[1]);
                            if (path[2].equals(Spoon.STRING_CONNECTIONS)) {
                                object = new TreeSelection(path[2], DatabaseMeta.class, transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_STEPS)) {
                                object = new TreeSelection(path[2], StepMeta.class, transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_HOPS)) {
                                object = new TreeSelection(path[2], TransHopMeta.class, transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_PARTITIONS)) {
                                object = new TreeSelection(path[2], PartitionSchema.class, transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_SLAVES)) {
                                object = new TreeSelection(path[2], SlaveServer.class, transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_CLUSTERS)) {
                                object = new TreeSelection(path[2], ClusterSchema.class, transMeta);
                            }
                            this.executeExtensionPoint(new SpoonTreeDelegateExtension((AbstractMeta)transMeta, path, 3, objects));
                        }
                        if (!path[0].equals(Spoon.STRING_JOBS)) break;
                        JobMeta jobMeta = this.spoon.delegates.jobs.getJob(path[1]);
                        if (path[2].equals(Spoon.STRING_CONNECTIONS)) {
                            object = new TreeSelection(path[2], DatabaseMeta.class, jobMeta);
                        }
                        if (path[2].equals(Spoon.STRING_JOB_ENTRIES)) {
                            object = new TreeSelection(path[2], JobEntryCopy.class, jobMeta);
                        }
                        if (path[2].equals(Spoon.STRING_SLAVES)) {
                            object = new TreeSelection(path[2], SlaveServer.class, jobMeta);
                        }
                        this.executeExtensionPoint(new SpoonTreeDelegateExtension((AbstractMeta)jobMeta, path, 3, objects));
                        break;
                    }
                    case 4: {
                        DatabaseMeta databaseMeta;
                        String dbName;
                        TransMeta transMeta;
                        if (path[0].equals(Spoon.STRING_TRANSFORMATIONS) && (transMeta = this.spoon.delegates.trans.getTransformation(path[1])) != null) {
                            if (path[2].equals(Spoon.STRING_CONNECTIONS)) {
                                dbName = path[3];
                                databaseMeta = transMeta.findDatabase(dbName);
                                if (databaseMeta != null) {
                                    dbName = databaseMeta.getName();
                                }
                                object = new TreeSelection(dbName, databaseMeta, transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_STEPS)) {
                                object = new TreeSelection(path[3], transMeta.findStep(path[3]), transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_HOPS)) {
                                object = new TreeSelection(path[3], transMeta.findTransHop(path[3]), transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_PARTITIONS)) {
                                object = new TreeSelection(path[3], transMeta.findPartitionSchema(path[3]), transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_SLAVES)) {
                                object = new TreeSelection(path[3], transMeta.findSlaveServer(path[3]), transMeta);
                            }
                            if (path[2].equals(Spoon.STRING_CLUSTERS)) {
                                object = new TreeSelection(path[3], transMeta.findClusterSchema(path[3]), transMeta);
                            }
                            this.executeExtensionPoint(new SpoonTreeDelegateExtension((AbstractMeta)transMeta, path, 4, objects));
                        }
                        if (!path[0].equals(Spoon.STRING_JOBS)) break;
                        JobMeta jobMeta = this.spoon.delegates.jobs.getJob(path[1]);
                        if (jobMeta != null && path[2].equals(Spoon.STRING_CONNECTIONS)) {
                            dbName = path[3];
                            databaseMeta = jobMeta.findDatabase(dbName);
                            if (databaseMeta != null) {
                                dbName = databaseMeta.getName();
                            }
                            object = new TreeSelection(dbName, databaseMeta, jobMeta);
                        }
                        if (jobMeta != null && path[2].equals(Spoon.STRING_JOB_ENTRIES)) {
                            object = new TreeSelection(path[3], jobMeta.findJobEntry(path[3]), jobMeta);
                        }
                        if (jobMeta != null && path[2].equals(Spoon.STRING_SLAVES)) {
                            object = new TreeSelection(path[3], jobMeta.findSlaveServer(path[3]), jobMeta);
                        }
                        this.executeExtensionPoint(new SpoonTreeDelegateExtension((AbstractMeta)jobMeta, path, 4, objects));
                        break;
                    }
                    case 5: {
                        TransMeta transMeta;
                        if (!path[0].equals(Spoon.STRING_TRANSFORMATIONS) || (transMeta = this.spoon.delegates.trans.getTransformation(path[1])) == null || !path[2].equals(Spoon.STRING_CLUSTERS)) break;
                        ClusterSchema clusterSchema = transMeta.findClusterSchema(path[3]);
                        object = new TreeSelection(path[4], clusterSchema.findSlaveServer(path[4]), clusterSchema, transMeta);
                        break;
                    }
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        if (tree != null && coreObjectsTree != null && tree.equals(coreObjectsTree)) {
            selection = coreObjectsTree.getSelection();
            for (s = 0; s < selection.length; ++s) {
                treeItem = selection[s];
                path = ConstUI.getTreeStrings(treeItem);
                object = null;
                switch (path.length) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        if (this.spoon.showJob) {
                            Class<JobEntryPluginType> pluginType;
                            PluginRegistry registry = PluginRegistry.getInstance();
                            PluginInterface plugin = registry.findPluginWithName(pluginType = JobEntryPluginType.class, path[1]);
                            if (plugin == null && path[1].equals("START")) {
                                plugin = registry.findPluginWithId(pluginType, "SPECIAL");
                            }
                            if (plugin == null && path[1].equals("DUMMY")) {
                                plugin = registry.findPluginWithId(pluginType, "SPECIAL");
                            }
                            if (plugin != null) {
                                object = new TreeSelection(path[1], plugin);
                            }
                        }
                        if (!this.spoon.showTrans) break;
                        object = new TreeSelection(path[1], PluginRegistry.getInstance().findPluginWithName(StepPluginType.class, path[1]));
                        break;
                    }
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects.toArray(new TreeSelection[objects.size()]);
    }

    public void addDragSourceToTree(final Tree tree, final Tree selectionTree, final Tree coreObjectsTree) {
        Transfer[] ttypes = new Transfer[]{XMLTransfer.getInstance()};
        DragSource ddSource = new DragSource((Control)tree, 2);
        ddSource.setTransfer(ttypes);
        ddSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                TreeSelection[] treeObjects = SpoonTreeDelegate.this.getTreeObjects(tree, selectionTree, coreObjectsTree);
                if (treeObjects.length == 0) {
                    event.doit = false;
                    return;
                }
                SpoonTreeDelegate.this.spoon.hideToolTips();
                TreeSelection treeObject = treeObjects[0];
                Object object = treeObject.getSelection();
                TransMeta transMeta = SpoonTreeDelegate.this.spoon.getActiveTransformation();
                event.doit = object instanceof StepMeta || object instanceof PluginInterface || object instanceof DatabaseMeta && transMeta != null || object instanceof TransHopMeta || object instanceof JobEntryCopy;
            }

            public void dragSetData(DragSourceEvent event) {
                TreeSelection[] treeObjects = SpoonTreeDelegate.this.getTreeObjects(tree, selectionTree, coreObjectsTree);
                if (treeObjects.length == 0) {
                    event.doit = false;
                    return;
                }
                int type = 0;
                String data = null;
                TreeSelection treeObject = treeObjects[0];
                Object object = treeObject.getSelection();
                if (object instanceof StepMeta) {
                    StepMeta stepMeta = (StepMeta)object;
                    type = 1;
                    data = stepMeta.getName();
                } else if (object instanceof PluginInterface) {
                    PluginInterface plugin = (PluginInterface)object;
                    Class pluginType = plugin.getPluginType();
                    if (Const.classIsOrExtends((Class)pluginType, StepPluginType.class)) {
                        type = 2;
                        data = plugin.getName();
                    } else {
                        type = 7;
                        data = plugin.getName();
                        if (treeObject.getItemText().equals(JobMeta.createStartEntry().getName())) {
                            data = treeObject.getItemText();
                        } else if (treeObject.getItemText().equals(JobMeta.createDummyEntry().getName())) {
                            data = treeObject.getItemText();
                        }
                    }
                } else if (object instanceof DatabaseMeta) {
                    DatabaseMeta databaseMeta = (DatabaseMeta)object;
                    type = 3;
                    data = databaseMeta.getName();
                } else if (object instanceof TransHopMeta) {
                    TransHopMeta hop = (TransHopMeta)object;
                    type = 4;
                    data = hop.toString();
                } else if (object instanceof JobEntryCopy) {
                    JobEntryCopy jobEntryCopy = (JobEntryCopy)object;
                    type = 6;
                    data = jobEntryCopy.getName();
                } else {
                    event.doit = false;
                    return;
                }
                event.data = new DragAndDropContainer(type, data);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private void executeExtensionPoint(SpoonTreeDelegateExtension extension) {
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.SpoonTreeDelegateExtension.id, (Object)extension);
        }
        catch (Exception e) {
            this.log.logError("Error handling SpoonTreeDelegate through extension point", (Throwable)e);
        }
    }
}

