/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.capabilities.api.ICapability;
import org.pentaho.capabilities.impl.DefaultCapabilityManager;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class CapabilityManagerDialog {
    private final Shell parent;
    private final PropsUI props;
    private Shell shell;
    private List<Button> buttons = new ArrayList<Button>();

    public CapabilityManagerDialog(Shell parent) {
        this.parent = parent;
        this.props = PropsUI.getInstance();
    }

    public static void main(String[] args) {
        Display display = new Display();
        try {
            KettleEnvironment.init();
            PropsUI.init(display, 1);
            KettleLogStore.init((int)PropsUI.getInstance().getMaxNrLinesInLog(), (int)PropsUI.getInstance().getMaxLogLineTimeoutMinutes());
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.SPOON);
        Shell shell = new Shell(display, 2144);
        shell.open();
        CapabilityManagerDialog capabilityManagerDialog = new CapabilityManagerDialog(shell);
        capabilityManagerDialog.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void open() {
        final Display display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(this.getClass(), (String)"CapabilityManager.Dialog.Title", (String[])new String[0]));
        int margin = 4;
        Button closeButton = new Button((Composite)this.shell, 8);
        closeButton.setText(BaseMessages.getString(this.getClass(), (String)"System.Button.Close", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{closeButton}, margin, null);
        closeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CapabilityManagerDialog.this.shell.dispose();
            }
        });
        ScrolledComposite scrollpane = new ScrolledComposite((Composite)this.shell, 2560);
        FormData treeFormData = new FormData();
        treeFormData.left = new FormAttachment(0, 0);
        treeFormData.top = new FormAttachment(0, 0);
        treeFormData.right = new FormAttachment(100, 0);
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Capabilities:");
        label.setLayoutData((Object)treeFormData);
        treeFormData = new FormData();
        treeFormData.left = new FormAttachment(0, 0);
        treeFormData.top = new FormAttachment((Control)label, 0);
        treeFormData.right = new FormAttachment(100, 0);
        treeFormData.bottom = new FormAttachment((Control)closeButton, -margin * 2);
        scrollpane.setLayoutData((Object)treeFormData);
        scrollpane.setExpandVertical(true);
        scrollpane.setExpandHorizontal(true);
        scrollpane.setAlwaysShowScrollBars(true);
        Composite mainPanel = new Composite((Composite)scrollpane, 0);
        scrollpane.setContent((Control)mainPanel);
        scrollpane.setSize(250, 400);
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        Set allCapabilities = DefaultCapabilityManager.getInstance().getAllCapabilities();
        TreeSet capabilitySortedSet = new TreeSet(allCapabilities);
        for (final ICapability capability : capabilitySortedSet) {
            final Button button = new Button(mainPanel, 32);
            button.setLayoutData((Object)new GridData(1808, 1, false, false));
            button.setSelection(capability.isInstalled());
            button.setText(capability.getId());
            this.buttons.add(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    final boolean selected = ((Button)selectionEvent.widget).getSelection();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Future future = selected ? capability.install() : capability.uninstall();
                            try {
                                final Boolean successful = (Boolean)future.get();
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        button.setSelection(successful.booleanValue());
                                        if (!successful.booleanValue()) {
                                            MessageDialog dialog = new MessageDialog(CapabilityManagerDialog.this.shell, "Capability Install Error", null, "Error Installing Capability:\n\n" + capability.getId(), 1, new String[]{"OK"}, 0);
                                            dialog.open();
                                        } else {
                                            MessageDialog dialog = new MessageDialog(CapabilityManagerDialog.this.shell, "Capability Install Success", null, capability.getId() + " " + (!selected ? "un" : "") + "installed successfully", 2, new String[]{"OK"}, 0);
                                            dialog.open();
                                        }
                                        CapabilityManagerDialog.this.updateAllCheckboxes();
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (ExecutionException e) {
                                e.printStackTrace();
                            }
                        }
                    }).run();
                }
            });
        }
        mainPanel.setSize(mainPanel.computeSize(-1, -1));
        scrollpane.setMinSize(mainPanel.computeSize(-1, -1));
        BaseStepDialog.setSize(this.shell, 250, 400, false);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void updateAllCheckboxes() {
        DefaultCapabilityManager capabilityManager = DefaultCapabilityManager.getInstance();
        for (Button button : this.buttons) {
            button.setSelection(capabilityManager.getCapabilityById(button.getText()).isInstalled());
        }
    }
}

