/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.debug.BreakPointListener;
import org.pentaho.di.trans.debug.StepDebugMeta;
import org.pentaho.di.trans.debug.TransDebugMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.trans.dialog.TransDialog;

public class TransPreviewProgressDialog {
    private static Class<?> PKG = TransDialog.class;
    private Shell shell;
    private TransMeta transMeta;
    private String[] previewStepNames;
    private int[] previewSize;
    private Trans trans;
    private boolean cancelled;
    private String loggingText;
    private TransDebugMeta transDebugMeta;

    public TransPreviewProgressDialog(Shell shell, TransMeta transMeta, String[] previewStepNames, int[] previewSize) {
        this.shell = shell;
        this.transMeta = transMeta;
        this.previewStepNames = previewStepNames;
        this.previewSize = previewSize;
        this.cancelled = false;
    }

    public TransMeta open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TransPreviewProgressDialog.this.doPreview(monitor);
            }
        };
        try {
            final ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    IProgressMonitor monitor = pmd.getProgressMonitor();
                    while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (monitor.isCanceled()) {
                        try {
                            TransPreviewProgressDialog.this.trans.stopAll();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransPreviewProgressDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransPreviewProgressDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
            this.transMeta = null;
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransPreviewProgressDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransPreviewProgressDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
            this.transMeta = null;
        }
        return this.transMeta;
    }

    private void doPreview(final IProgressMonitor progressMonitor) {
        progressMonitor.beginTask(BaseMessages.getString(PKG, (String)"TransPreviewProgressDialog.Monitor.BeginTask.Title", (String[])new String[0]), 100);
        this.trans = new Trans(this.transMeta);
        this.trans.setPreview(true);
        try {
            this.trans.prepareExecution(null);
        }
        catch (KettleException e) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    new ErrorDialog(TransPreviewProgressDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"TransPreviewProgressDialog.Exception.ErrorPreparingTransformation", (String[])new String[0]), (Exception)((Object)e));
                }
            });
            return;
        }
        this.transDebugMeta = new TransDebugMeta(this.transMeta);
        for (int i = 0; i < this.previewStepNames.length; ++i) {
            StepMeta stepMeta = this.transMeta.findStep(this.previewStepNames[i]);
            StepDebugMeta stepDebugMeta = new StepDebugMeta(stepMeta);
            stepDebugMeta.setReadingFirstRows(true);
            stepDebugMeta.setRowCount(this.previewSize[i]);
            this.transDebugMeta.getStepDebugMetaMap().put(stepMeta, stepDebugMeta);
        }
        this.transDebugMeta.addRowListenersToTransformation(this.trans);
        try {
            this.trans.startThreads();
        }
        catch (KettleException e) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    new ErrorDialog(TransPreviewProgressDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"TransPreviewProgressDialog.Exception.ErrorPreparingTransformation", (String[])new String[0]), (Exception)((Object)e));
                }
            });
            return;
        }
        int previousPct = 0;
        final ArrayList previewComplete = new ArrayList();
        while (previewComplete.size() < this.previewStepNames.length && !this.trans.isFinished() && !progressMonitor.isCanceled()) {
            this.transDebugMeta.addBreakPointListers(new BreakPointListener(){

                public void breakPointHit(TransDebugMeta transDebugMeta, StepDebugMeta stepDebugMeta, RowMetaInterface rowBufferMeta, List<Object[]> rowBuffer) {
                    String stepName = stepDebugMeta.getStepMeta().getName();
                    previewComplete.add(stepName);
                    progressMonitor.subTask(BaseMessages.getString((Class)PKG, (String)"TransPreviewProgressDialog.SubTask.StepPreviewFinished", (String[])new String[]{stepName}));
                }
            });
            int nrDone = 0;
            int nrTotal = 0;
            for (StepDebugMeta stepDebugMeta : this.transDebugMeta.getStepDebugMetaMap().values()) {
                nrDone += stepDebugMeta.getRowBuffer().size();
                nrTotal += stepDebugMeta.getRowCount();
            }
            int pct = 100 * nrDone / nrTotal;
            int worked = pct - previousPct;
            if (worked > 0) {
                progressMonitor.worked(worked);
            }
            previousPct = pct;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!progressMonitor.isCanceled()) continue;
            this.cancelled = true;
            this.trans.stopAll();
        }
        this.trans.stopAll();
        this.loggingText = KettleLogStore.getAppender().getBuffer(this.trans.getLogChannel().getLogChannelId(), true).toString();
        progressMonitor.done();
    }

    public List<Object[]> getPreviewRows(String stepname) {
        if (this.transDebugMeta == null) {
            return null;
        }
        for (StepMeta stepMeta : this.transDebugMeta.getStepDebugMetaMap().keySet()) {
            if (!stepMeta.getName().equals(stepname)) continue;
            StepDebugMeta stepDebugMeta = (StepDebugMeta)this.transDebugMeta.getStepDebugMetaMap().get(stepMeta);
            return stepDebugMeta.getRowBuffer();
        }
        return null;
    }

    public RowMetaInterface getPreviewRowsMeta(String stepname) {
        if (this.transDebugMeta == null) {
            return null;
        }
        for (StepMeta stepMeta : this.transDebugMeta.getStepDebugMetaMap().keySet()) {
            if (!stepMeta.getName().equals(stepname)) continue;
            StepDebugMeta stepDebugMeta = (StepDebugMeta)this.transDebugMeta.getStepDebugMetaMap().get(stepMeta);
            return stepDebugMeta.getRowBufferMeta();
        }
        return null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getLoggingText() {
        return this.loggingText;
    }

    public Trans getTrans() {
        return this.trans;
    }

    public TransDebugMeta getTransDebugMeta() {
        return this.transDebugMeta;
    }
}

